/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.service;

import com.baomidou.jobs.model.JobsInfo;
import com.baomidou.jobs.service.IJobsService;
import com.baomidou.jobs.service.JobsHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;

public class JobsHeartbeat
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(JobsHeartbeat.class);
    private long wait = 0L;
    private long beat = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            log.debug("Jobs, JobsHeartbeat begin");
            IJobsService jobsService = JobsHelper.getJobsService();
            try {
                if (jobsService.tryLock("JOBS_LOCK")) {
                    this.wait = 0L;
                    long nowTime = System.currentTimeMillis();
                    List<JobsInfo> scheduleList = jobsService.getJobsInfoList(nowTime + 10000L);
                    if (scheduleList != null && scheduleList.size() > 0) {
                        for (JobsInfo jobsInfo : scheduleList) {
                            long waitSecond;
                            if (jobsInfo.getNextTime() < nowTime - 10000L) {
                                waitSecond = -1L;
                            } else {
                                if (jobsInfo.getNextTime() >= nowTime) continue;
                                waitSecond = nowTime - jobsInfo.getLastTime();
                            }
                            JobsInfo tempJobsInfo = new JobsInfo();
                            tempJobsInfo.setId(jobsInfo.getId());
                            tempJobsInfo.setLastTime(jobsInfo.getNextTime());
                            tempJobsInfo.setNextTime(JobsHelper.cronNextTime(jobsInfo.getCron()));
                            if (waitSecond >= 0L) {
                                JobsHelper.getJobsDisruptorTemplate().publish(jobsInfo, waitSecond);
                            }
                            jobsService.updateJobsInfoById(tempJobsInfo);
                        }
                    }
                }
                jobsService.unlock("JOBS_LOCK", this.wait > 90L);
                ++this.beat;
                if (this.beat <= 30L) break block14;
                jobsService.cleanTimeoutApp();
            }
            catch (Exception e) {
                try {
                    if (e instanceof DuplicateKeyException) {
                        ++this.wait;
                        if (log.isDebugEnabled()) {
                            log.debug("Jobs, JobsHeartbeat locking");
                        }
                    } else {
                        log.error("Jobs, JobsHeartbeat error:{}", (Throwable)e);
                    }
                    jobsService.unlock("JOBS_LOCK", this.wait > 90L);
                    ++this.beat;
                    if (this.beat <= 30L) break block14;
                    jobsService.cleanTimeoutApp();
                }
                catch (Throwable throwable) {
                    jobsService.unlock("JOBS_LOCK", this.wait > 90L);
                    ++this.beat;
                    if (this.beat > 30L) {
                        jobsService.cleanTimeoutApp();
                        this.beat = 0L;
                    }
                    throw throwable;
                }
                this.beat = 0L;
            }
            this.beat = 0L;
        }
        log.debug("Jobs, JobsHeartbeat end");
    }
}

