/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.service;

import com.baomidou.jobs.model.JobsInfo;
import com.baomidou.jobs.model.JobsLog;
import com.baomidou.jobs.model.param.RegistryParam;
import com.baomidou.jobs.trigger.JobsTrigger;
import com.baomidou.jobs.trigger.TriggerTypeEnum;
import java.util.List;
import java.util.UUID;

public interface IJobsService {
    public static final ThreadLocal<String> ownerThreadLocal = new ThreadLocal();

    public boolean registry(RegistryParam var1);

    default public boolean execute(Long jobId, String param) {
        return JobsTrigger.trigger(jobId, TriggerTypeEnum.MANUAL, -1, param);
    }

    public List<JobsInfo> getJobsInfoList(long var1);

    public JobsInfo getJobsInfoById(Long var1);

    public boolean updateJobsInfoById(JobsInfo var1);

    default public boolean tryLock(String lockKey) {
        String owner = ownerThreadLocal.get();
        if (null != owner && !owner.equals("OPERATION_TRY_LOCK")) {
            return true;
        }
        ownerThreadLocal.set("OPERATION_TRY_LOCK");
        owner = UUID.randomUUID().toString();
        if (this.tryLock(lockKey, owner)) {
            ownerThreadLocal.set(owner);
            return true;
        }
        return false;
    }

    default public void unlock(String lockKey, boolean force) {
        if (force) {
            this.unlock(lockKey, null);
        } else {
            String owner = ownerThreadLocal.get();
            if (null == owner) {
                throw new IllegalMonitorStateException("should not call unlock() without tryLock(()");
            }
            ownerThreadLocal.remove();
            if (!"OPERATION_TRY_LOCK".equals(owner)) {
                this.unlock(lockKey, owner);
            }
        }
    }

    public boolean tryLock(String var1, String var2);

    public boolean unlock(String var1, String var2);

    default public int cleanTimeoutApp() {
        return this.removeTimeOutApp(50000);
    }

    public int removeTimeOutApp(int var1);

    public boolean removeApp(RegistryParam var1);

    public List<String> getAppAddressList(String var1);

    public boolean saveOrUpdateLogById(JobsLog var1);
}

