/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.provider;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.registry.IJobsServiceRegistry;
import com.baomidou.jobs.rpc.remoting.net.NetEnum;
import com.baomidou.jobs.rpc.remoting.net.Server;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import com.baomidou.jobs.rpc.util.IpUtil;
import com.baomidou.jobs.rpc.util.NetUtil;
import com.baomidou.jobs.service.JobsHelper;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsRpcProviderFactory {
    private static final Logger log = LoggerFactory.getLogger(JobsRpcProviderFactory.class);
    private NetEnum netType;
    private IJobsRpcSerializer serializer;
    private String ip;
    private int port;
    private String accessToken;
    private Class<? extends IJobsServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private Server server;
    private IJobsServiceRegistry serviceRegistry;
    private String serviceAddress;
    private Map<String, Object> serviceData = new HashMap<String, Object>();

    public void initConfig(NetEnum netType, IJobsRpcSerializer serializer, String ip, int port, String accessToken, Class<? extends IJobsServiceRegistry> serviceRegistryClass, Map<String, String> serviceRegistryParam) {
        this.netType = netType;
        this.serializer = serializer;
        this.ip = ip;
        this.port = port;
        this.accessToken = accessToken;
        this.serviceRegistryClass = serviceRegistryClass;
        this.serviceRegistryParam = serviceRegistryParam;
        if (this.netType == null) {
            throw new JobsRpcException("Jobs rpc provider netType missing.");
        }
        if (this.serializer == null) {
            throw new JobsRpcException("Jobs rpc provider serializer missing.");
        }
        if (this.ip == null) {
            this.ip = IpUtil.getIp();
        }
        if (this.port <= 0) {
            this.port = 7080;
        }
        if (NetUtil.isPortUsed(this.port)) {
            throw new JobsRpcException("Jobs rpc provider port[" + this.port + "] is used.");
        }
        if (this.serviceRegistryClass != null && this.serviceRegistryParam == null) {
            throw new JobsRpcException("Jobs rpc provider serviceRegistryParam is missing.");
        }
    }

    public IJobsRpcSerializer getSerializer() {
        return this.serializer;
    }

    public int getPort() {
        return this.port;
    }

    public void start() throws Exception {
        this.serviceAddress = IpUtil.getIpPort(this.ip, this.port);
        this.server = this.netType.serverClass.newInstance();
        this.server.setStartedCallback(() -> {
            if (this.serviceRegistryClass != null) {
                try {
                    this.serviceRegistry = this.serviceRegistryClass.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                this.serviceRegistry.start(this.serviceRegistryParam);
                if (this.serviceData.size() > 0) {
                    this.serviceRegistry.registry(this.serviceData.keySet(), this.serviceAddress);
                }
            }
        });
        this.server.setStoppedCallback(() -> {
            if (this.serviceRegistry != null) {
                if (this.serviceData.size() > 0) {
                    this.serviceRegistry.remove(this.serviceData.keySet(), this.serviceAddress);
                }
                this.serviceRegistry.stop();
                this.serviceRegistry = null;
            }
        });
        this.server.start(this);
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public Map<String, Object> getServiceData() {
        return this.serviceData;
    }

    public static String makeServiceKey(String iface, String version) {
        String serviceKey = iface;
        if (version != null && version.trim().length() > 0) {
            serviceKey = serviceKey + "#".concat(version);
        }
        return serviceKey;
    }

    public void addService(String iface, String version, Object serviceBean) {
        String serviceKey = JobsRpcProviderFactory.makeServiceKey(iface, version);
        this.serviceData.put(serviceKey, serviceBean);
        log.info("Jobs rpc, provider factory add service success. serviceKey = {}, serviceBean = {}", (Object)serviceKey, serviceBean.getClass());
    }

    public JobsRpcResponse invokeService(JobsRpcRequest jobsRpcRequest) {
        JobsRpcResponse jobsRpcResponse = new JobsRpcResponse();
        jobsRpcResponse.setRequestId(jobsRpcRequest.getRequestId());
        String serviceKey = JobsRpcProviderFactory.makeServiceKey(jobsRpcRequest.getClassName(), jobsRpcRequest.getVersion());
        Object serviceBean = this.serviceData.get(serviceKey);
        if (null == serviceBean) {
            jobsRpcResponse.setErrorMsg("The serviceKey[" + serviceKey + "] not found.");
            return jobsRpcResponse;
        }
        if (System.currentTimeMillis() - jobsRpcRequest.getCreateMillisTime() > 180000L) {
            jobsRpcResponse.setErrorMsg("The timestamp difference between admin and executor exceeds the limit.");
            return jobsRpcResponse;
        }
        if (null != this.accessToken && this.accessToken.trim().length() > 0 && !this.accessToken.trim().equals(jobsRpcRequest.getAccessToken())) {
            jobsRpcResponse.setErrorMsg("The access token[" + jobsRpcRequest.getAccessToken() + "] is wrong.");
            return jobsRpcResponse;
        }
        try {
            Class<?> serviceClass = serviceBean.getClass();
            String methodName = jobsRpcRequest.getMethodName();
            Class<?>[] parameterTypes = jobsRpcRequest.getParameterTypes();
            Object[] parameters = jobsRpcRequest.getParameters();
            Method method = serviceClass.getMethod(methodName, parameterTypes);
            method.setAccessible(true);
            Object result = method.invoke(serviceBean, parameters);
            jobsRpcResponse.setResult(result);
        }
        catch (Throwable t) {
            log.error("Jobs rpc provider invokeService error.", t);
            jobsRpcResponse.setErrorMsg(JobsHelper.getErrorInfo(t));
        }
        return jobsRpcResponse;
    }
}

