/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.params;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.invoker.call.JobsRpcInvokeCallback;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JobsRpcFutureResponse
implements Future<JobsRpcResponse> {
    private JobsRpcInvokerFactory invokerFactory;
    private JobsRpcRequest request;
    private JobsRpcResponse response;
    private boolean done = false;
    private Object lock = new Object();
    private JobsRpcInvokeCallback invokeCallback;

    public JobsRpcFutureResponse(JobsRpcInvokerFactory invokerFactory, JobsRpcRequest request, JobsRpcInvokeCallback invokeCallback) {
        this.invokerFactory = invokerFactory;
        this.request = request;
        this.invokeCallback = invokeCallback;
        this.setInvokerFuture();
    }

    public void setInvokerFuture() {
        this.invokerFactory.setInvokerFuture(this.request.getRequestId(), this);
    }

    public void removeInvokerFuture() {
        this.invokerFactory.removeInvokerFuture(this.request.getRequestId());
    }

    public JobsRpcRequest getRequest() {
        return this.request;
    }

    public JobsRpcInvokeCallback getInvokeCallback() {
        return this.invokeCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(JobsRpcResponse response) {
        this.response = response;
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public JobsRpcResponse get() throws InterruptedException, ExecutionException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new JobsRpcException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobsRpcResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            Object object = this.lock;
            synchronized (object) {
                if (timeout < 0L) {
                    this.lock.wait();
                } else {
                    long timeoutMillis = TimeUnit.MILLISECONDS == unit ? timeout : TimeUnit.MILLISECONDS.convert(timeout, unit);
                    this.lock.wait(timeoutMillis);
                }
            }
        }
        if (!this.done) {
            throw new JobsRpcException("Jobs rpc, request timeout at:" + System.currentTimeMillis() + ", request:" + this.request.toString());
        }
        return this.response;
    }
}

