/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.servlet.server;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.service.JobsHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletServerHandler {
    private static final Logger log = LoggerFactory.getLogger(ServletServerHandler.class);
    private JobsRpcProviderFactory jobsRpcProviderFactory;

    public ServletServerHandler(JobsRpcProviderFactory jobsRpcProviderFactory) {
        this.jobsRpcProviderFactory = jobsRpcProviderFactory;
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JobsRpcRequest jobsRpcRequest;
        if ("/services".equals(target)) {
            StringBuffer stringBuffer = new StringBuffer("<ui>");
            for (String serviceKey : this.jobsRpcProviderFactory.getServiceData().keySet()) {
                stringBuffer.append("<li>").append(serviceKey).append(": ").append(this.jobsRpcProviderFactory.getServiceData().get(serviceKey)).append("</li>");
            }
            stringBuffer.append("</ui>");
            this.writeResponse(response, stringBuffer.toString().getBytes());
            return;
        }
        try {
            jobsRpcRequest = this.parseRequest(request);
        }
        catch (Exception e) {
            this.writeResponse(response, JobsHelper.getErrorInfo(e).getBytes());
            return;
        }
        JobsRpcResponse xxlRpcResponse = this.jobsRpcProviderFactory.invokeService(jobsRpcRequest);
        byte[] responseBytes = this.jobsRpcProviderFactory.getSerializer().serialize(xxlRpcResponse);
        this.writeResponse(response, responseBytes);
    }

    private void writeResponse(HttpServletResponse response, byte[] responseBytes) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(200);
        ServletOutputStream out = response.getOutputStream();
        out.write(responseBytes);
        out.flush();
    }

    private JobsRpcRequest parseRequest(HttpServletRequest request) throws Exception {
        byte[] requestBytes = ServletServerHandler.readBytes(request);
        if (requestBytes == null || requestBytes.length == 0) {
            throw new JobsRpcException("Jobs rpc request data is empty.");
        }
        return (JobsRpcRequest)this.jobsRpcProviderFactory.getSerializer().deserialize(requestBytes, JobsRpcRequest.class);
    }

    public static final byte[] readBytes(HttpServletRequest request) throws IOException {
        request.setCharacterEncoding("UTF-8");
        int contentLen = request.getContentLength();
        ServletInputStream is = request.getInputStream();
        if (contentLen > 0) {
            byte[] message = new byte[contentLen];
            try {
                int readLengthThisTime;
                for (int readLen = 0; readLen != contentLen && (readLengthThisTime = is.read(message, readLen, contentLen - readLen)) != -1; readLen += readLengthThisTime) {
                }
                return message;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return new byte[0];
    }
}

