/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.server;

import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.service.JobsHelper;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends SimpleChannelInboundHandler<JobsRpcRequest> {
    private static final Logger log = LoggerFactory.getLogger(NettyServerHandler.class);
    private JobsRpcProviderFactory xxlRpcProviderFactory;
    private ThreadPoolExecutor serverHandlerPool;

    public NettyServerHandler(JobsRpcProviderFactory xxlRpcProviderFactory, ThreadPoolExecutor serverHandlerPool) {
        this.xxlRpcProviderFactory = xxlRpcProviderFactory;
        this.serverHandlerPool = serverHandlerPool;
    }

    public void channelRead0(ChannelHandlerContext ctx, JobsRpcRequest xxlRpcRequest) throws Exception {
        try {
            this.serverHandlerPool.execute(() -> {
                JobsRpcResponse xxlRpcResponse = this.xxlRpcProviderFactory.invokeService(xxlRpcRequest);
                ctx.writeAndFlush((Object)xxlRpcResponse);
            });
        }
        catch (Exception e) {
            JobsRpcResponse jobsRpcResponse = new JobsRpcResponse();
            jobsRpcResponse.setRequestId(xxlRpcRequest.getRequestId());
            jobsRpcResponse.setErrorMsg(JobsHelper.getErrorInfo(e));
            ctx.writeAndFlush((Object)jobsRpcResponse);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error("Jobs rpc provider netty server caught exception", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
            log.debug("Jobs rpc provider netty server close an idle channel.");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

