/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.server;

import com.baomidou.jobs.rpc.remoting.net.Server;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.codec.NettyDecoder;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.codec.NettyEncoder;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.server.NettyServerHandler;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.rpc.util.ThreadPoolUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
extends Server {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Thread thread;

    @Override
    public void start(final JobsRpcProviderFactory jobsRpcProviderFactory) throws Exception {
        this.thread = new Thread(() -> {
            final ThreadPoolExecutor serverHandlerPool = ThreadPoolUtil.makeServerThreadPool(NettyServer.class.getSimpleName());
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            NioEventLoopGroup workerGroup = new NioEventLoopGroup();
            try {
                ServerBootstrap bootstrap = new ServerBootstrap();
                ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                    public void initChannel(SocketChannel channel) throws Exception {
                        channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 10L, TimeUnit.MINUTES)}).addLast(new ChannelHandler[]{new NettyDecoder(JobsRpcRequest.class, jobsRpcProviderFactory.getSerializer())}).addLast(new ChannelHandler[]{new NettyEncoder(JobsRpcResponse.class, jobsRpcProviderFactory.getSerializer())}).addLast(new ChannelHandler[]{new NettyServerHandler(jobsRpcProviderFactory, serverHandlerPool)});
                    }
                }).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
                ChannelFuture future = bootstrap.bind(jobsRpcProviderFactory.getPort()).sync();
                log.info("Jobs rpc remoting server start success, nettype = {}, port = {}", (Object)NettyServer.class.getName(), (Object)jobsRpcProviderFactory.getPort());
                this.onStarted();
                future.channel().closeFuture().sync();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    log.info("Jobs rpc remoting server stop.");
                } else {
                    log.error("Jobs rpc remoting server error.", (Throwable)e);
                }
            }
            finally {
                try {
                    serverHandlerPool.shutdown();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    workerGroup.shutdownGracefully();
                    bossGroup.shutdownGracefully();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    @Override
    public void stop() throws Exception {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
        }
        this.onStopped();
        log.info("Jobs rpc remoting server destroy success.");
    }
}

