/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.client;

import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.net.common.ConnectClient;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.client.NettyClientHandler;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.codec.NettyDecoder;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.codec.NettyEncoder;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import com.baomidou.jobs.rpc.util.IpUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyConnectClient
extends ConnectClient {
    private static final Logger log = LoggerFactory.getLogger(NettyConnectClient.class);
    private EventLoopGroup group;
    private Channel channel;

    @Override
    public void init(String address, final IJobsRpcSerializer serializer, final JobsRpcInvokerFactory xxlRpcInvokerFactory) throws Exception {
        Object[] array = IpUtil.parseIpPort(address);
        String host = (String)array[0];
        int port = (Integer)array[1];
        this.group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 10L, TimeUnit.MINUTES)}).addLast(new ChannelHandler[]{new NettyEncoder(JobsRpcRequest.class, serializer)}).addLast(new ChannelHandler[]{new NettyDecoder(JobsRpcResponse.class, serializer)}).addLast(new ChannelHandler[]{new NettyClientHandler(xxlRpcInvokerFactory)});
            }
        })).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
        this.channel = bootstrap.connect(host, port).sync().channel();
        if (!this.isValidate()) {
            this.close();
            return;
        }
        log.debug("Jobs rpc netty client proxy, connect to server success at host:{}, port:{}", (Object)host, (Object)port);
    }

    @Override
    public boolean isValidate() {
        if (this.channel != null) {
            return this.channel.isActive();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.channel != null && this.channel.isActive()) {
            this.channel.close();
        }
        if (this.group != null && !this.group.isShutdown()) {
            this.group.shutdownGracefully();
        }
        log.debug("Jobs rpc netty client close.");
    }

    @Override
    public void send(JobsRpcRequest xxlRpcRequest) throws Exception {
        this.channel.writeAndFlush((Object)xxlRpcRequest).sync();
    }
}

