/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.socket.client;

import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientHandler
extends SimpleChannelInboundHandler<JobsRpcResponse> {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientHandler.class);
    private JobsRpcInvokerFactory jobsRpcInvokerFactory;

    public NettyClientHandler(JobsRpcInvokerFactory jobsRpcInvokerFactory) {
        this.jobsRpcInvokerFactory = jobsRpcInvokerFactory;
    }

    protected void channelRead0(ChannelHandlerContext ctx, JobsRpcResponse xxlRpcResponse) throws Exception {
        this.jobsRpcInvokerFactory.notifyInvokerFuture(xxlRpcResponse.getRequestId(), xxlRpcResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Jobs rpc netty client caught exception", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
            logger.debug("Jobs rpc netty client close an idle channel.");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

