/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.http.server;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.service.JobsHelper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateEvent;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(NettyHttpServerHandler.class);
    private JobsRpcProviderFactory xxlRpcProviderFactory;
    private ThreadPoolExecutor serverHandlerPool;

    public NettyHttpServerHandler(JobsRpcProviderFactory xxlRpcProviderFactory, ThreadPoolExecutor serverHandlerPool) {
        this.xxlRpcProviderFactory = xxlRpcProviderFactory;
        this.serverHandlerPool = serverHandlerPool;
    }

    protected void channelRead0(final ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        final byte[] requestBytes = ByteBufUtil.getBytes((ByteBuf)msg.content());
        final String uri = msg.uri();
        final boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)msg);
        this.serverHandlerPool.execute(new Runnable(){

            @Override
            public void run() {
                NettyHttpServerHandler.this.process(ctx, uri, requestBytes, keepAlive);
            }
        });
    }

    private void process(ChannelHandlerContext ctx, String uri, byte[] requestBytes, boolean keepAlive) {
        String requestId = null;
        try {
            if ("/services".equals(uri)) {
                StringBuffer stringBuffer = new StringBuffer("<ui>");
                for (String serviceKey : this.xxlRpcProviderFactory.getServiceData().keySet()) {
                    stringBuffer.append("<li>").append(serviceKey).append(": ").append(this.xxlRpcProviderFactory.getServiceData().get(serviceKey)).append("</li>");
                }
                stringBuffer.append("</ui>");
                byte[] responseBytes = stringBuffer.toString().getBytes("UTF-8");
                this.writeResponse(ctx, keepAlive, responseBytes);
            } else {
                if (requestBytes.length == 0) {
                    throw new JobsRpcException("Jobs rpc request data empty.");
                }
                JobsRpcRequest xxlRpcRequest = (JobsRpcRequest)this.xxlRpcProviderFactory.getSerializer().deserialize(requestBytes, JobsRpcRequest.class);
                requestId = xxlRpcRequest.getRequestId();
                JobsRpcResponse xxlRpcResponse = this.xxlRpcProviderFactory.invokeService(xxlRpcRequest);
                byte[] responseBytes = this.xxlRpcProviderFactory.getSerializer().serialize(xxlRpcResponse);
                this.writeResponse(ctx, keepAlive, responseBytes);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            JobsRpcResponse xxlRpcResponse = new JobsRpcResponse();
            xxlRpcResponse.setRequestId(requestId);
            xxlRpcResponse.setErrorMsg(JobsHelper.getErrorInfo(e));
            byte[] responseBytes = this.xxlRpcProviderFactory.getSerializer().serialize(xxlRpcResponse);
            this.writeResponse(ctx, keepAlive, responseBytes);
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, boolean keepAlive, byte[] responseBytes) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])responseBytes));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        if (keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.writeAndFlush((Object)response);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("Jobs rpc provider netty_http server caught exception", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
            logger.debug("Jobs rpc provider netty_http server close an idle channel.");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

