/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.http.client;

import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.net.common.ConnectClient;
import com.baomidou.jobs.rpc.remoting.net.impl.netty.http.client.NettyHttpClientHandler;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateHandler;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpConnectClient
extends ConnectClient {
    private static final Logger log = LoggerFactory.getLogger(NettyHttpConnectClient.class);
    private EventLoopGroup group;
    private Channel channel;
    private IJobsRpcSerializer serializer;
    private String address;
    private String host;

    @Override
    public void init(String address, final IJobsRpcSerializer serializer, final JobsRpcInvokerFactory xxlRpcInvokerFactory) throws Exception {
        if (!address.toLowerCase().startsWith("http")) {
            address = "http://" + address;
        }
        this.address = address;
        URL url = new URL(address);
        this.host = url.getHost();
        int port = url.getPort() > -1 ? url.getPort() : 80;
        this.group = new NioEventLoopGroup();
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(0L, 0L, 10L, TimeUnit.MINUTES)}).addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new HttpObjectAggregator(0x500000)}).addLast(new ChannelHandler[]{new NettyHttpClientHandler(xxlRpcInvokerFactory, serializer)});
            }
        })).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.channel = bootstrap.connect(this.host, port).sync().channel();
        this.serializer = serializer;
        if (!this.isValidate()) {
            this.close();
            return;
        }
        log.debug("Jobs rpc netty client proxy, connect to server success at host:{}, port:{}", (Object)this.host, (Object)port);
    }

    @Override
    public boolean isValidate() {
        if (this.channel != null) {
            return this.channel.isActive();
        }
        return false;
    }

    @Override
    public void close() {
        if (this.channel != null && this.channel.isActive()) {
            this.channel.close();
        }
        if (this.group != null && !this.group.isShutdown()) {
            this.group.shutdownGracefully();
        }
        log.debug("Jobs rpc netty client close.");
    }

    @Override
    public void send(JobsRpcRequest xxlRpcRequest) throws Exception {
        byte[] requestBytes = this.serializer.serialize(xxlRpcRequest);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, new URI(this.address).getRawPath(), Unpooled.wrappedBuffer((byte[])requestBytes));
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)this.host);
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes());
        this.channel.writeAndFlush((Object)request).sync();
    }
}

