/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.impl.netty.http.client;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClientHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private static final Logger logger = LoggerFactory.getLogger(NettyHttpClientHandler.class);
    private JobsRpcInvokerFactory xxlRpcInvokerFactory;
    private IJobsRpcSerializer serializer;

    public NettyHttpClientHandler(JobsRpcInvokerFactory xxlRpcInvokerFactory, IJobsRpcSerializer serializer) {
        this.xxlRpcInvokerFactory = xxlRpcInvokerFactory;
        this.serializer = serializer;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        byte[] responseBytes = ByteBufUtil.getBytes((ByteBuf)msg.content());
        if (responseBytes.length == 0) {
            throw new JobsRpcException("Jobs rpc request data empty.");
        }
        JobsRpcResponse xxlRpcResponse = (JobsRpcResponse)this.serializer.deserialize(responseBytes, JobsRpcResponse.class);
        this.xxlRpcInvokerFactory.notifyInvokerFuture(xxlRpcResponse.getRequestId(), xxlRpcResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error("Jobs rpc netty_http client caught exception", cause);
        ctx.close();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            ctx.channel().close();
            logger.debug("Jobs rpc netty_http client close an idle channel.");
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }
}

