/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net.common;

import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.invoker.reference.JobsRpcReferenceBean;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectClient {
    private static final Logger log = LoggerFactory.getLogger(ConnectClient.class);
    private static volatile ConcurrentHashMap<String, ConnectClient> connectClientMap;
    private static volatile ConcurrentHashMap<String, Object> connectClientLockMap;

    public abstract void init(String var1, IJobsRpcSerializer var2, JobsRpcInvokerFactory var3) throws Exception;

    public abstract void close();

    public abstract boolean isValidate();

    public abstract void send(JobsRpcRequest var1) throws Exception;

    public static void asyncSend(JobsRpcRequest xxlRpcRequest, String address, Class<? extends ConnectClient> connectClientImpl, JobsRpcReferenceBean xxlRpcReferenceBean) throws Exception {
        ConnectClient clientPool = ConnectClient.getPool(address, connectClientImpl, xxlRpcReferenceBean);
        clientPool.send(xxlRpcRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static ConnectClient getPool(String address, Class<? extends ConnectClient> connectClientImpl, JobsRpcReferenceBean jobsRpcReferenceBean) throws Exception {
        ConnectClient connectClient;
        if (connectClientMap == null) {
            Class<ConnectClient> clazz = ConnectClient.class;
            // MONITORENTER : com.baomidou.jobs.rpc.remoting.net.common.ConnectClient.class
            if (connectClientMap == null) {
                connectClientMap = new ConcurrentHashMap(16);
                jobsRpcReferenceBean.getInvokerFactory().addStopCallBack(() -> {
                    if (connectClientMap.size() > 0) {
                        for (String key : connectClientMap.keySet()) {
                            ConnectClient clientPool = connectClientMap.get(key);
                            clientPool.close();
                        }
                        connectClientMap.clear();
                    }
                });
            }
            // MONITOREXIT : clazz
        }
        if ((connectClient = connectClientMap.get(address)) != null && connectClient.isValidate()) {
            return connectClient;
        }
        Object clientLock = connectClientLockMap.get(address);
        if (clientLock == null) {
            connectClientLockMap.putIfAbsent(address, new Object());
            clientLock = connectClientLockMap.get(address);
        }
        Object object = clientLock;
        // MONITORENTER : object
        connectClient = connectClientMap.get(address);
        if (connectClient != null && connectClient.isValidate()) {
            // MONITOREXIT : object
            return connectClient;
        }
        if (connectClient != null) {
            connectClient.close();
            connectClientMap.remove(address);
        }
        ConnectClient connectClient_new = connectClientImpl.newInstance();
        try {
            connectClient_new.init(address, jobsRpcReferenceBean.getSerializer(), jobsRpcReferenceBean.getInvokerFactory());
            connectClientMap.put(address, connectClient_new);
            return connectClient_new;
        }
        catch (Exception e) {
            connectClient_new.close();
            throw e;
        }
    }

    static {
        connectClientLockMap = new ConcurrentHashMap();
    }
}

