/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.net;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.net.params.IJobsRpcCallback;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Server {
    private static final Logger log = LoggerFactory.getLogger(Server.class);
    private IJobsRpcCallback startedCallback;
    private IJobsRpcCallback stoppedCallback;

    public abstract void start(JobsRpcProviderFactory var1) throws Exception;

    public void onStarted() {
        if (this.startedCallback != null) {
            try {
                this.startedCallback.execute();
            }
            catch (JobsRpcException e) {
                log.error("Jobs rpc, server startedCallback error.", (Throwable)e);
            }
        }
    }

    public abstract void stop() throws Exception;

    public void onStopped() {
        if (null != this.stoppedCallback) {
            try {
                this.stoppedCallback.execute();
            }
            catch (JobsRpcException e) {
                log.error("Jobs rpc, server stoppedCallback error.", (Throwable)e);
            }
        }
    }

    public void setStartedCallback(IJobsRpcCallback startedCallback) {
        this.startedCallback = startedCallback;
    }

    public void setStoppedCallback(IJobsRpcCallback stoppedCallback) {
        this.stoppedCallback = stoppedCallback;
    }
}

