/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.invoker.reference;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.invoker.call.CallType;
import com.baomidou.jobs.rpc.remoting.invoker.call.JobsRpcInvokeCallback;
import com.baomidou.jobs.rpc.remoting.invoker.call.JobsRpcInvokeFuture;
import com.baomidou.jobs.rpc.remoting.invoker.generic.JobsRpcGenericService;
import com.baomidou.jobs.rpc.remoting.invoker.route.LoadBalance;
import com.baomidou.jobs.rpc.remoting.net.Client;
import com.baomidou.jobs.rpc.remoting.net.NetEnum;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcFutureResponse;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcRequest;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import com.baomidou.jobs.rpc.util.ClassUtil;
import java.lang.reflect.Proxy;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsRpcReferenceBean {
    private static final Logger log = LoggerFactory.getLogger(JobsRpcReferenceBean.class);
    private NetEnum netType;
    private IJobsRpcSerializer serializer;
    private CallType callType;
    private LoadBalance loadBalance;
    private Class<?> iface;
    private String version;
    private long timeout = 1000L;
    private String address;
    private String accessToken;
    private JobsRpcInvokeCallback invokeCallback;
    private JobsRpcInvokerFactory invokerFactory;
    Client client = null;

    public JobsRpcReferenceBean(NetEnum netType, IJobsRpcSerializer serializer, CallType callType, LoadBalance loadBalance, Class<?> iface, String version, long timeout, String address, String accessToken, JobsRpcInvokeCallback invokeCallback, JobsRpcInvokerFactory invokerFactory) {
        this.netType = netType;
        this.serializer = serializer;
        this.callType = callType;
        this.loadBalance = loadBalance;
        this.iface = iface;
        this.version = version;
        this.timeout = timeout;
        this.address = address;
        this.accessToken = accessToken;
        this.invokeCallback = invokeCallback;
        this.invokerFactory = invokerFactory;
        if (this.netType == null) {
            throw new JobsRpcException("Jobs rpc reference netType missing.");
        }
        if (this.serializer == null) {
            throw new JobsRpcException("Jobs rpc reference serializer missing.");
        }
        if (this.callType == null) {
            throw new JobsRpcException("Jobs rpc reference callType missing.");
        }
        if (this.loadBalance == null) {
            throw new JobsRpcException("Jobs rpc reference loadBalance missing.");
        }
        if (this.iface == null) {
            throw new JobsRpcException("Jobs rpc reference iface missing.");
        }
        if (this.timeout < 0L) {
            this.timeout = 0L;
        }
        if (this.invokerFactory == null) {
            this.invokerFactory = JobsRpcInvokerFactory.getInstance();
        }
        this.initClient();
    }

    public IJobsRpcSerializer getSerializer() {
        return this.serializer;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public JobsRpcInvokerFactory getInvokerFactory() {
        return this.invokerFactory;
    }

    private void initClient() {
        try {
            this.client = this.netType.clientClass.newInstance();
            this.client.init(this);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JobsRpcException(e);
        }
    }

    public Object getObject() {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.iface}, (proxy, method, args) -> {
            String className = method.getDeclaringClass().getName();
            String varsion_ = this.version;
            String methodName = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] parameters = args;
            if (className.equals(JobsRpcGenericService.class.getName()) && methodName.equals("invoke")) {
                String[] paramTypes_str;
                Class[] paramTypes = null;
                if (args[3] != null && (paramTypes_str = (String[])args[3]).length > 0) {
                    paramTypes = new Class[paramTypes_str.length];
                    for (int i = 0; i < paramTypes_str.length; ++i) {
                        paramTypes[i] = ClassUtil.resolveClass(paramTypes_str[i]);
                    }
                }
                className = (String)args[0];
                varsion_ = (String)args[1];
                methodName = (String)args[2];
                parameterTypes = paramTypes;
                parameters = (Object[])args[4];
            }
            if (className.equals(Object.class.getName())) {
                log.info("Jobs rpc proxy class-method not support [{}#{}]", (Object)className, (Object)methodName);
                throw new JobsRpcException("Jobs rpc proxy class-method not support");
            }
            String finalAddress = this.address;
            if ((finalAddress == null || finalAddress.trim().length() == 0) && this.invokerFactory != null && this.invokerFactory.getServiceRegistry() != null) {
                String serviceKey = JobsRpcProviderFactory.makeServiceKey(className, varsion_);
                TreeSet<String> addressSet = this.invokerFactory.getServiceRegistry().discovery(serviceKey);
                if (addressSet != null && addressSet.size() != 0) {
                    finalAddress = addressSet.size() == 1 ? addressSet.first() : this.loadBalance.rpcLoadBalance.route(serviceKey, addressSet);
                }
            }
            if (finalAddress == null || finalAddress.trim().length() == 0) {
                throw new JobsRpcException("Jobs rpc reference bean[" + className + "] address empty");
            }
            JobsRpcRequest jobsRpcRequest = new JobsRpcRequest();
            jobsRpcRequest.setRequestId(UUID.randomUUID().toString());
            jobsRpcRequest.setCreateMillisTime(System.currentTimeMillis());
            jobsRpcRequest.setAccessToken(this.accessToken);
            jobsRpcRequest.setClassName(className);
            jobsRpcRequest.setMethodName(methodName);
            jobsRpcRequest.setParameterTypes(parameterTypes);
            jobsRpcRequest.setParameters(parameters);
            if (CallType.SYNC == this.callType) {
                JobsRpcFutureResponse futureResponse = new JobsRpcFutureResponse(this.invokerFactory, jobsRpcRequest, null);
                try {
                    this.client.asyncSend(finalAddress, jobsRpcRequest);
                    JobsRpcResponse xxlRpcResponse = futureResponse.get(this.timeout, TimeUnit.MILLISECONDS);
                    if (xxlRpcResponse.getErrorMsg() != null) {
                        throw new JobsRpcException(xxlRpcResponse.getErrorMsg());
                    }
                    Object object = xxlRpcResponse.getResult();
                    return object;
                }
                catch (Exception e) {
                    log.info("Jobs rpc, invoke error, address:{}, JobsRpcRequest{}", (Object)finalAddress, (Object)jobsRpcRequest);
                    throw e instanceof JobsRpcException ? e : new JobsRpcException(e);
                }
                finally {
                    futureResponse.removeInvokerFuture();
                }
            }
            if (CallType.FUTURE == this.callType) {
                JobsRpcFutureResponse futureResponse = new JobsRpcFutureResponse(this.invokerFactory, jobsRpcRequest, null);
                try {
                    JobsRpcInvokeFuture invokeFuture = new JobsRpcInvokeFuture(futureResponse);
                    JobsRpcInvokeFuture.setFuture(invokeFuture);
                    this.client.asyncSend(finalAddress, jobsRpcRequest);
                    return null;
                }
                catch (Exception e) {
                    log.info("Jobs rpc, invoke error, address:{}, JobsRpcRequest{}", (Object)finalAddress, (Object)jobsRpcRequest);
                    futureResponse.removeInvokerFuture();
                    throw e instanceof JobsRpcException ? e : new JobsRpcException(e);
                }
            }
            if (CallType.CALLBACK == this.callType) {
                JobsRpcInvokeCallback finalInvokeCallback = this.invokeCallback;
                JobsRpcInvokeCallback threadInvokeCallback = JobsRpcInvokeCallback.getCallback();
                if (threadInvokeCallback != null) {
                    finalInvokeCallback = threadInvokeCallback;
                }
                if (finalInvokeCallback == null) {
                    throw new JobsRpcException("Jobs rpc JobsRpcInvokeCallback\uff08CallType=" + CallType.CALLBACK.name() + "\uff09 cannot be null.");
                }
                JobsRpcFutureResponse futureResponse = new JobsRpcFutureResponse(this.invokerFactory, jobsRpcRequest, finalInvokeCallback);
                try {
                    this.client.asyncSend(finalAddress, jobsRpcRequest);
                }
                catch (Exception e) {
                    log.info("Jobs rpc, invoke error, address:{}, JobsRpcRequest{}", (Object)finalAddress, (Object)jobsRpcRequest);
                    futureResponse.removeInvokerFuture();
                    throw e instanceof JobsRpcException ? e : new JobsRpcException(e);
                }
                return null;
            }
            if (CallType.ONEWAY == this.callType) {
                this.client.asyncSend(finalAddress, jobsRpcRequest);
                return null;
            }
            throw new JobsRpcException("Jobs rpc callType[" + (Object)((Object)this.callType) + "] invalid");
        });
    }

    public Class<?> getObjectType() {
        return this.iface;
    }
}

