/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.invoker.call;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcFutureResponse;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class JobsRpcInvokeFuture
implements Future {
    private JobsRpcFutureResponse futureResponse;
    private static ThreadLocal<JobsRpcInvokeFuture> threadInvokerFuture = new ThreadLocal();

    public JobsRpcInvokeFuture(JobsRpcFutureResponse futureResponse) {
        this.futureResponse = futureResponse;
    }

    public void stop() {
        this.futureResponse.removeInvokerFuture();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futureResponse.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.futureResponse.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.futureResponse.isDone();
    }

    public Object get() throws ExecutionException, InterruptedException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new JobsRpcException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            JobsRpcResponse xxlRpcResponse = this.futureResponse.get(timeout, unit);
            if (xxlRpcResponse.getErrorMsg() != null) {
                throw new JobsRpcException(xxlRpcResponse.getErrorMsg());
            }
            Object object = xxlRpcResponse.getResult();
            return object;
        }
        finally {
            this.stop();
        }
    }

    public static <T> Future<T> getFuture(Class<T> type) {
        Future future = threadInvokerFuture.get();
        threadInvokerFuture.remove();
        return future;
    }

    public static void setFuture(JobsRpcInvokeFuture future) {
        threadInvokerFuture.set(future);
    }

    public static void removeFuture() {
        threadInvokerFuture.remove();
    }
}

