/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.remoting.invoker;

import com.baomidou.jobs.exception.JobsRpcException;
import com.baomidou.jobs.rpc.registry.IJobsServiceRegistry;
import com.baomidou.jobs.rpc.registry.impl.LocalServiceRegistry;
import com.baomidou.jobs.rpc.remoting.net.params.IJobsRpcCallback;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcFutureResponse;
import com.baomidou.jobs.rpc.remoting.net.params.JobsRpcResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsRpcInvokerFactory {
    private static Logger logger = LoggerFactory.getLogger(JobsRpcInvokerFactory.class);
    private static volatile JobsRpcInvokerFactory instance = new JobsRpcInvokerFactory(LocalServiceRegistry.class, null);
    private Class<? extends IJobsServiceRegistry> serviceRegistryClass;
    private Map<String, String> serviceRegistryParam;
    private IJobsServiceRegistry serviceRegistry;
    private List<IJobsRpcCallback> stopCallbackList = new ArrayList<IJobsRpcCallback>();
    private ConcurrentMap<String, JobsRpcFutureResponse> futureResponsePool = new ConcurrentHashMap<String, JobsRpcFutureResponse>();
    private ThreadPoolExecutor responseCallbackThreadPool = null;

    public static JobsRpcInvokerFactory getInstance() {
        return instance;
    }

    public JobsRpcInvokerFactory() {
    }

    public JobsRpcInvokerFactory(Class<? extends IJobsServiceRegistry> serviceRegistryClass, Map<String, String> serviceRegistryParam) {
        this.serviceRegistryClass = serviceRegistryClass;
        this.serviceRegistryParam = serviceRegistryParam;
    }

    public void start() throws Exception {
        if (this.serviceRegistryClass != null) {
            this.serviceRegistry = this.serviceRegistryClass.newInstance();
            this.serviceRegistry.start(this.serviceRegistryParam);
        }
    }

    public void stop() throws Exception {
        if (this.serviceRegistry != null) {
            this.serviceRegistry.stop();
        }
        if (this.stopCallbackList.size() > 0) {
            for (IJobsRpcCallback callback : this.stopCallbackList) {
                try {
                    callback.execute();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.stopCallbackThreadPool();
    }

    public IJobsServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void addStopCallBack(IJobsRpcCallback callback) {
        this.stopCallbackList.add(callback);
    }

    public void setInvokerFuture(String requestId, JobsRpcFutureResponse futureResponse) {
        this.futureResponsePool.put(requestId, futureResponse);
    }

    public void removeInvokerFuture(String requestId) {
        this.futureResponsePool.remove(requestId);
    }

    public void notifyInvokerFuture(String requestId, JobsRpcResponse jobsRpcResponse) {
        JobsRpcFutureResponse futureResponse = (JobsRpcFutureResponse)this.futureResponsePool.get(requestId);
        if (futureResponse == null) {
            return;
        }
        if (futureResponse.getInvokeCallback() != null) {
            try {
                this.executeResponseCallback(() -> {
                    if (jobsRpcResponse.getErrorMsg() != null) {
                        futureResponse.getInvokeCallback().onFailure(new JobsRpcException(jobsRpcResponse.getErrorMsg()));
                    } else {
                        futureResponse.getInvokeCallback().onSuccess(jobsRpcResponse.getResult());
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            futureResponse.setResponse(jobsRpcResponse);
        }
        this.futureResponsePool.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeResponseCallback(Runnable runnable) {
        if (this.responseCallbackThreadPool == null) {
            JobsRpcInvokerFactory jobsRpcInvokerFactory = this;
            synchronized (jobsRpcInvokerFactory) {
                if (this.responseCallbackThreadPool == null) {
                    this.responseCallbackThreadPool = new ThreadPoolExecutor(10, 100, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), r -> new Thread(r, "Jobs rpc, JobsRpcInvokerFactory-responseCallbackThreadPool-" + r.hashCode()), (r, executor) -> {
                        throw new JobsRpcException("Jobs rpc Invoke Callback Thread pool is EXHAUSTED!");
                    });
                }
            }
        }
        this.responseCallbackThreadPool.execute(runnable);
    }

    public void stopCallbackThreadPool() {
        if (this.responseCallbackThreadPool != null) {
            this.responseCallbackThreadPool.shutdown();
        }
    }
}

