/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.rpc.registry.client;

import com.baomidou.jobs.rpc.registry.client.JobsRegistryBaseClient;
import com.baomidou.jobs.rpc.registry.client.model.JobsRegistryDataParamVO;
import com.baomidou.jobs.rpc.registry.client.util.json.BasicJson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsRegistryClient {
    private static final Logger log = LoggerFactory.getLogger(JobsRegistryClient.class);
    private volatile Set<JobsRegistryDataParamVO> registryData = new HashSet<JobsRegistryDataParamVO>();
    private volatile ConcurrentMap<String, TreeSet<String>> discoveryData = new ConcurrentHashMap<String, TreeSet<String>>();
    private Thread registryThread;
    private Thread discoveryThread;
    private volatile boolean registryThreadStop = false;
    private JobsRegistryBaseClient registryBaseClient;

    public JobsRegistryClient(String adminAddress, String accessToken, String biz, String env) {
        this.registryBaseClient = new JobsRegistryBaseClient(adminAddress, accessToken, biz, env);
        log.info("Jobs registry, JobsRegistryClient init .... [adminAddress={}, accessToken={}, biz={}, env={}]", new Object[]{adminAddress, accessToken, biz, env});
        this.registryThread = new Thread(() -> {
            while (!this.registryThreadStop) {
                block6: {
                    try {
                        if (this.registryData.size() > 0) {
                            boolean ret = this.registryBaseClient.registry(new ArrayList<JobsRegistryDataParamVO>(this.registryData));
                            log.debug("Jobs registry, refresh registry data {}, registryData = {}", (Object)(ret ? "success" : "fail"), this.registryData);
                        }
                    }
                    catch (Exception e) {
                        if (this.registryThreadStop) break block6;
                        log.error("Jobs registry, registryThread error.", (Throwable)e);
                    }
                }
                try {
                    TimeUnit.SECONDS.sleep(10L);
                }
                catch (Exception e) {
                    if (this.registryThreadStop) continue;
                    log.error("Jobs registry, registryThread error.", (Throwable)e);
                }
            }
            log.info("Jobs registry, registryThread stoped.");
        });
        this.registryThread.setName("jobs-registry, JobsRegistryClient registryThread.");
        this.registryThread.setDaemon(true);
        this.registryThread.start();
        this.discoveryThread = new Thread(() -> {
            while (!this.registryThreadStop) {
                if (this.discoveryData.size() == 0) {
                    try {
                        TimeUnit.SECONDS.sleep(3L);
                    }
                    catch (Exception e) {
                        if (this.registryThreadStop) continue;
                        log.error("Jobs registry, discoveryThread error.", (Throwable)e);
                    }
                    continue;
                }
                try {
                    boolean monitorRet = this.registryBaseClient.monitor(this.discoveryData.keySet());
                    if (!monitorRet) {
                        TimeUnit.SECONDS.sleep(10L);
                    }
                    this.refreshDiscoveryData(this.discoveryData.keySet());
                }
                catch (Exception e) {
                    if (this.registryThreadStop) continue;
                    log.error("Jobs registry, discoveryThread error.", (Throwable)e);
                }
            }
            log.info("Jobs registry, discoveryThread stoped.");
        });
        this.discoveryThread.setName("jobs-registry, JobsRegistryClient discoveryThread.");
        this.discoveryThread.setDaemon(true);
        this.discoveryThread.start();
        log.info("Jobs registry, JobsRegistryClient init success.");
    }

    public void stop() {
        this.registryThreadStop = true;
        if (this.registryThread != null) {
            this.registryThread.interrupt();
        }
        if (this.discoveryThread != null) {
            this.discoveryThread.interrupt();
        }
    }

    public boolean registry(List<JobsRegistryDataParamVO> registryDataList) {
        if (registryDataList == null || registryDataList.size() == 0) {
            throw new RuntimeException("jobs-registry registryDataList empty");
        }
        for (JobsRegistryDataParamVO registryParam : registryDataList) {
            if (registryParam.getKey() == null || registryParam.getKey().trim().length() < 4 || registryParam.getKey().trim().length() > 255) {
                throw new RuntimeException("jobs-registry registryDataList#key Invalid[4~255]");
            }
            if (registryParam.getValue() != null && registryParam.getValue().trim().length() >= 4 && registryParam.getValue().trim().length() <= 255) continue;
            throw new RuntimeException("jobs-registry registryDataList#value Invalid[4~255]");
        }
        this.registryData.addAll(registryDataList);
        this.registryBaseClient.registry(registryDataList);
        return true;
    }

    public boolean remove(List<JobsRegistryDataParamVO> registryDataList) {
        if (registryDataList == null || registryDataList.size() == 0) {
            throw new RuntimeException("jobs-registry registryDataList empty");
        }
        for (JobsRegistryDataParamVO registryParam : registryDataList) {
            if (registryParam.getKey() == null || registryParam.getKey().trim().length() < 4 || registryParam.getKey().trim().length() > 255) {
                throw new RuntimeException("jobs-registry registryDataList#key Invalid[4~255]");
            }
            if (registryParam.getValue() != null && registryParam.getValue().trim().length() >= 4 && registryParam.getValue().trim().length() <= 255) continue;
            throw new RuntimeException("jobs-registry registryDataList#value Invalid[4~255]");
        }
        this.registryData.removeAll(registryDataList);
        this.registryBaseClient.remove(registryDataList);
        return true;
    }

    public Map<String, TreeSet<String>> discovery(Set<String> keys) {
        TreeSet valueSet;
        if (keys == null || keys.size() == 0) {
            return null;
        }
        HashMap<String, TreeSet<String>> registryDataTmp = new HashMap<String, TreeSet<String>>();
        for (String key : keys) {
            valueSet = (TreeSet)this.discoveryData.get(key);
            if (valueSet == null) continue;
            registryDataTmp.put(key, valueSet);
        }
        if (keys.size() != registryDataTmp.size()) {
            this.refreshDiscoveryData(keys);
            for (String key : keys) {
                valueSet = (TreeSet)this.discoveryData.get(key);
                if (valueSet == null) continue;
                registryDataTmp.put(key, valueSet);
            }
        }
        return registryDataTmp;
    }

    private void refreshDiscoveryData(Set<String> keys) {
        if (keys == null || keys.size() == 0) {
            return;
        }
        HashMap updatedData = new HashMap();
        Map<String, TreeSet<String>> keyValueListData = this.registryBaseClient.discovery(keys);
        if (keyValueListData != null) {
            for (String keyItem : keyValueListData.keySet()) {
                TreeSet valueSet = new TreeSet();
                valueSet.addAll(keyValueListData.get(keyItem));
                boolean updated = true;
                TreeSet oldValSet = (TreeSet)this.discoveryData.get(keyItem);
                if (oldValSet != null && BasicJson.toJson(oldValSet).equals(BasicJson.toJson(valueSet))) {
                    updated = false;
                }
                if (!updated) continue;
                this.discoveryData.put(keyItem, valueSet);
                updatedData.put(keyItem, valueSet);
            }
        }
        if (updatedData.size() > 0) {
            log.info("Jobs registry, refresh discovery data finish, discoveryData(updated) = {}", updatedData);
        }
        log.debug("Jobs registry, refresh discovery data finish, discoveryData = {}", this.discoveryData);
    }

    public TreeSet<String> discovery(String key) {
        if (key == null) {
            return null;
        }
        Map<String, TreeSet<String>> keyValueSetTmp = this.discovery(new HashSet<String>(Arrays.asList(key)));
        if (keyValueSetTmp != null) {
            return keyValueSetTmp.get(key);
        }
        return null;
    }
}

