/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.router;

import com.baomidou.jobs.router.IJobsExecutorRouter;
import com.baomidou.jobs.toolkit.ConsistentHash;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorConsistentHashRouter
implements IJobsExecutorRouter {
    private static final Logger log = LoggerFactory.getLogger(ExecutorConsistentHashRouter.class);

    @Override
    public String route(String app, List<String> addressList) {
        if (null == app || null == addressList) {
            return null;
        }
        int nodeCount = addressList.size();
        if (0 == nodeCount) {
            return null;
        }
        if (nodeCount <= 1) {
            return addressList.get(0);
        }
        ConsistentHash<String> consistentHash = new ConsistentHash<String>(nodeCount *= 10);
        consistentHash.add(addressList);
        String address = consistentHash.getNode(app + new Random().nextInt(nodeCount));
        log.debug("{} Consistent Hash Address [ {} ]", (Object)app, (Object)address);
        return address;
    }
}

