/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.executor;

import com.baomidou.jobs.executor.JobsAbstractExecutor;
import com.baomidou.jobs.handler.IJobsHandler;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JobsSpringExecutor
extends JobsAbstractExecutor
implements ApplicationContextAware {
    @Autowired
    private IJobsRpcSerializer jobsRpcSerializer;
    private static ApplicationContext applicationContext;

    @Override
    public void start() throws Exception {
        this.initJobHandlerRepository(applicationContext);
        super.start();
    }

    private void initJobHandlerRepository(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        String[] jobsHandlerArr = applicationContext.getBeanNamesForType(IJobsHandler.class);
        if (null != jobsHandlerArr && jobsHandlerArr.length > 0) {
            for (String jobsHandler : jobsHandlerArr) {
                JobsSpringExecutor.putJobsHandler(jobsHandler, (IJobsHandler)applicationContext.getBean(jobsHandler));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        JobsSpringExecutor.applicationContext = applicationContext;
    }

    @Override
    public IJobsRpcSerializer getJobsRpcSerializer() {
        return this.jobsRpcSerializer;
    }
}

