/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.executor;

import com.baomidou.jobs.executor.IJobsExecutor;
import com.baomidou.jobs.executor.JobsExecutor;
import com.baomidou.jobs.handler.IJobsHandler;
import com.baomidou.jobs.rpc.registry.IJobsServiceRegistry;
import com.baomidou.jobs.rpc.remoting.invoker.JobsRpcInvokerFactory;
import com.baomidou.jobs.rpc.remoting.invoker.call.CallType;
import com.baomidou.jobs.rpc.remoting.invoker.reference.JobsRpcReferenceBean;
import com.baomidou.jobs.rpc.remoting.invoker.route.LoadBalance;
import com.baomidou.jobs.rpc.remoting.net.NetEnum;
import com.baomidou.jobs.rpc.remoting.provider.JobsRpcProviderFactory;
import com.baomidou.jobs.rpc.serialize.IJobsRpcSerializer;
import com.baomidou.jobs.rpc.util.IpUtil;
import com.baomidou.jobs.rpc.util.NetUtil;
import com.baomidou.jobs.service.IJobsService;
import com.baomidou.jobs.thread.ExecutorRegistryThread;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class JobsAbstractExecutor {
    private static final Logger log = LoggerFactory.getLogger(JobsAbstractExecutor.class);
    private String adminAddress;
    private String app;
    private String ip;
    private int port;
    private String accessToken;
    private static List<IJobsService> JOBS_SERVICE;
    private JobsRpcProviderFactory JOBS_RPC_PROVIDER_FACTORY = null;
    private static Map<String, IJobsHandler> JOBS_HANDLER;

    public void start() throws Exception {
        this.initJobsAdminList(this.adminAddress, this.accessToken);
        this.port = this.port > 0 ? this.port : NetUtil.findAvailablePort(9999);
        this.ip = this.ip != null && this.ip.trim().length() > 0 ? this.ip : IpUtil.getIp();
        this.initRpcProvider(this.ip, this.port, this.app, this.accessToken);
    }

    public void destroy() {
        JOBS_HANDLER.clear();
        this.stopRpcProvider();
        this.stopInvokerFactory();
    }

    public abstract IJobsRpcSerializer getJobsRpcSerializer();

    private void initJobsAdminList(String adminAddress, String accessToken) throws Exception {
        if (!StringUtils.isEmpty((Object)adminAddress)) {
            String[] addressArr;
            if (JOBS_SERVICE == null) {
                JOBS_SERVICE = new ArrayList<IJobsService>();
            }
            for (String address : addressArr = adminAddress.trim().split(",")) {
                if (address == null || address.trim().length() <= 0) continue;
                String addressUrl = address.concat("/jobs-api");
                IJobsService jobsAdmin = (IJobsService)new JobsRpcReferenceBean(NetEnum.NETTY_HTTP, this.getJobsRpcSerializer(), CallType.SYNC, LoadBalance.ROUND, IJobsService.class, null, 10000L, addressUrl, accessToken, null, null).getObject();
                JOBS_SERVICE.add(jobsAdmin);
            }
        }
    }

    private void stopInvokerFactory() {
        try {
            JobsRpcInvokerFactory.getInstance().stop();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<IJobsService> getJobsServiceList() {
        return JOBS_SERVICE;
    }

    private void initRpcProvider(String ip, int port, String appName, String accessToken) throws Exception {
        HashMap<String, String> serviceRegistryParam = new HashMap<String, String>(16);
        serviceRegistryParam.put("appName", appName);
        serviceRegistryParam.put("address", IpUtil.getIpPort(ip, port));
        this.JOBS_RPC_PROVIDER_FACTORY = new JobsRpcProviderFactory();
        this.JOBS_RPC_PROVIDER_FACTORY.initConfig(NetEnum.NETTY_HTTP, this.getJobsRpcSerializer(), ip, port, accessToken, ExecutorServiceRegistry.class, serviceRegistryParam);
        this.JOBS_RPC_PROVIDER_FACTORY.addService(IJobsExecutor.class.getName(), null, new JobsExecutor());
        this.JOBS_RPC_PROVIDER_FACTORY.start();
    }

    private void stopRpcProvider() {
        try {
            this.JOBS_RPC_PROVIDER_FACTORY.stop();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static IJobsHandler putJobsHandler(String name, IJobsHandler jobHandler) {
        log.debug("jobs handler register success, name:{}", (Object)name);
        return JOBS_HANDLER.put(name, jobHandler);
    }

    public static IJobsHandler getJobsHandler(String name) {
        return JOBS_HANDLER.get(name);
    }

    public String getAdminAddress() {
        return this.adminAddress;
    }

    public String getApp() {
        return this.app;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public JobsRpcProviderFactory getJOBS_RPC_PROVIDER_FACTORY() {
        return this.JOBS_RPC_PROVIDER_FACTORY;
    }

    public void setAdminAddress(String adminAddress) {
        this.adminAddress = adminAddress;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setJOBS_RPC_PROVIDER_FACTORY(JobsRpcProviderFactory JOBS_RPC_PROVIDER_FACTORY) {
        this.JOBS_RPC_PROVIDER_FACTORY = JOBS_RPC_PROVIDER_FACTORY;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobsAbstractExecutor)) {
            return false;
        }
        JobsAbstractExecutor other = (JobsAbstractExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$adminAddress = this.getAdminAddress();
        String other$adminAddress = other.getAdminAddress();
        if (this$adminAddress == null ? other$adminAddress != null : !this$adminAddress.equals(other$adminAddress)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        JobsRpcProviderFactory this$JOBS_RPC_PROVIDER_FACTORY = this.getJOBS_RPC_PROVIDER_FACTORY();
        JobsRpcProviderFactory other$JOBS_RPC_PROVIDER_FACTORY = other.getJOBS_RPC_PROVIDER_FACTORY();
        return !(this$JOBS_RPC_PROVIDER_FACTORY == null ? other$JOBS_RPC_PROVIDER_FACTORY != null : !this$JOBS_RPC_PROVIDER_FACTORY.equals(other$JOBS_RPC_PROVIDER_FACTORY));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobsAbstractExecutor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $adminAddress = this.getAdminAddress();
        result = result * 59 + ($adminAddress == null ? 43 : $adminAddress.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        result = result * 59 + this.getPort();
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        JobsRpcProviderFactory $JOBS_RPC_PROVIDER_FACTORY = this.getJOBS_RPC_PROVIDER_FACTORY();
        result = result * 59 + ($JOBS_RPC_PROVIDER_FACTORY == null ? 43 : $JOBS_RPC_PROVIDER_FACTORY.hashCode());
        return result;
    }

    public String toString() {
        return "JobsAbstractExecutor(adminAddress=" + this.getAdminAddress() + ", app=" + this.getApp() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", accessToken=" + this.getAccessToken() + ", JOBS_RPC_PROVIDER_FACTORY=" + this.getJOBS_RPC_PROVIDER_FACTORY() + ")";
    }

    static {
        JOBS_HANDLER = new ConcurrentHashMap<String, IJobsHandler>();
    }

    public static class ExecutorServiceRegistry
    implements IJobsServiceRegistry {
        @Override
        public void start(Map<String, String> param) {
            ExecutorRegistryThread.getInstance().start(param.get("appName"), param.get("address"));
        }

        @Override
        public void stop() {
            ExecutorRegistryThread.getInstance().toStop();
        }

        @Override
        public boolean registry(Set<String> keys, String value) {
            return false;
        }

        @Override
        public boolean remove(Set<String> keys, String value) {
            return false;
        }

        @Override
        public Map<String, TreeSet<String>> discovery(Set<String> keys) {
            return null;
        }

        @Override
        public TreeSet<String> discovery(String key) {
            return null;
        }
    }
}

