/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.disruptor;

import com.baomidou.jobs.disruptor.JobsInfoEvent;
import com.baomidou.jobs.model.JobsInfo;
import com.baomidou.jobs.trigger.JobsTrigger;
import com.baomidou.jobs.trigger.TriggerTypeEnum;
import com.lmax.disruptor.EventHandler;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsEventHandler
implements EventHandler<JobsInfoEvent> {
    private static final Logger log = LoggerFactory.getLogger(JobsEventHandler.class);

    public void onEvent(JobsInfoEvent jobsInfoEvent, long sequence, boolean endOfBatch) throws Exception {
        JobsInfo jobsInfo = jobsInfoEvent.getJobsInfo();
        if (null != jobsInfo) {
            if (jobsInfoEvent.getWaitSecond() > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(jobsInfoEvent.getWaitSecond());
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Jobs Event Handler: {}", (Object)jobsInfo.toString());
            }
            JobsTrigger.trigger(jobsInfo.getId(), TriggerTypeEnum.CRON, -1, null);
        }
    }
}

