/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.jobs.api;

import com.baomidou.jobs.api.IJobsErrorCode;
import com.baomidou.jobs.api.JobsErrorCode;
import java.io.Serializable;
import java.util.Optional;

public class JobsResponse
implements Serializable {
    private int code;
    private String msg;

    public JobsResponse() {
    }

    public JobsResponse(IJobsErrorCode errorCode) {
        errorCode = Optional.ofNullable(errorCode).orElse(JobsErrorCode.FAILED);
        this.code = errorCode.getCode();
        this.msg = errorCode.getMsg();
    }

    public static JobsResponse ok() {
        return JobsResponse.restResult(JobsErrorCode.SUCCESS);
    }

    public static JobsResponse failed(String msg) {
        return JobsResponse.restResult(JobsErrorCode.FAILED.getCode(), msg);
    }

    public static JobsResponse restResult(IJobsErrorCode errorCode) {
        return JobsResponse.restResult(errorCode.getCode(), errorCode.getMsg());
    }

    private static JobsResponse restResult(int code, String msg) {
        JobsResponse apiResult = new JobsResponse();
        apiResult.setCode(code);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public JobsResponse setCode(int code) {
        this.code = code;
        return this;
    }

    public JobsResponse setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobsResponse)) {
            return false;
        }
        JobsResponse other = (JobsResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        return !(this$msg == null ? other$msg != null : !this$msg.equals(other$msg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobsResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        return result;
    }

    public String toString() {
        return "JobsResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ")";
    }
}

