/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.brpc.client.loadbalance;

import com.baidu.brpc.client.RpcClient;
import com.baidu.brpc.client.channel.BrpcChannel;
import com.baidu.brpc.client.loadbalance.LoadBalanceStrategy;
import com.baidu.brpc.protocol.Request;
import com.baidu.brpc.utils.CollectionUtils;
import com.baidu.brpc.utils.CustomThreadFactory;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FairStrategy
implements LoadBalanceStrategy {
    private static final Logger log = LoggerFactory.getLogger(FairStrategy.class);
    private static final int TIMER_DELAY = 60;
    private CopyOnWriteArrayList<Node> treeContainer;
    private volatile Timer timer;
    private RpcClient rpcClient;
    private int latencyWindowSize;
    private float activeInstancesRatio;
    private int minInstancesNum = 3;
    private CopyOnWriteArrayList<BrpcChannel> invalidInstances;
    private Random random = new Random(System.currentTimeMillis());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(RpcClient rpcClient) {
        if (this.timer == null) {
            FairStrategy fairStrategy = this;
            synchronized (fairStrategy) {
                if (this.timer == null) {
                    this.timer = new HashedWheelTimer((ThreadFactory)new CustomThreadFactory("fairStrategy-timer-thread"));
                    this.timer.newTimeout(new TimerTask(){

                        public void run(Timeout timeout) {
                            FairStrategy.this.updateWeightTree();
                            FairStrategy.this.timer.newTimeout((TimerTask)this, 60L, TimeUnit.SECONDS);
                        }
                    }, 60L, TimeUnit.SECONDS);
                    this.rpcClient = rpcClient;
                    this.treeContainer = new CopyOnWriteArrayList();
                    this.invalidInstances = new CopyOnWriteArrayList();
                    this.latencyWindowSize = rpcClient.getRpcClientOptions().getLatencyWindowSizeOfFairLoadBalance();
                    this.activeInstancesRatio = rpcClient.getRpcClientOptions().getActiveInstancesRatioOfFairLoadBalance();
                    if (this.latencyWindowSize <= 1) {
                        throw new IllegalArgumentException("latencyWindowSize must be greater than 1");
                    }
                }
            }
        }
    }

    @Override
    public BrpcChannel selectInstance(Request request, List<BrpcChannel> instances, Set<BrpcChannel> selectedInstances) {
        if (this.treeContainer.size() == 0) {
            return this.randomSelect(instances);
        }
        try {
            Node root = this.treeContainer.get(0);
            BrpcChannel selectedChannelGroup = this.fairSelect(root);
            if (this.invalidInstances.contains(selectedChannelGroup)) {
                log.debug("the selected one is invalid, begin to random reselect a new one...");
                return this.randomSelect(instances);
            }
            return selectedChannelGroup;
        }
        catch (Exception e) {
            log.warn("FairStrategy select channel failed.", (Throwable)e);
            return this.randomSelect(instances);
        }
    }

    @Override
    public void destroy() {
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    public void markInvalidInstance(List<BrpcChannel> instances) {
        this.invalidInstances.addAll(instances);
    }

    protected BrpcChannel randomSelect(List<BrpcChannel> instances) {
        long instanceNum = instances.size();
        if (instanceNum == 0L) {
            return null;
        }
        int index = (int)(this.getRandomLong() % instanceNum);
        return instances.get(index);
    }

    protected long getRandomLong() {
        long randomIndex = this.random.nextLong();
        if (randomIndex < 0L) {
            randomIndex = 0L - randomIndex;
        }
        return randomIndex;
    }

    protected BrpcChannel fairSelect(Node root) {
        int max = root.weight;
        int randomWeight = this.random.nextInt(max);
        Node selectNode = this.searchNode(root, randomWeight);
        return selectNode.server;
    }

    protected Node searchNode(Node parent, int weight) {
        if (parent.left == null) {
            return parent;
        }
        if (parent.right == null) {
            return parent.left;
        }
        if (parent.left.weight >= weight) {
            return this.searchNode(parent.left, weight);
        }
        return this.searchNode(parent.right, weight - parent.left.weight);
    }

    protected void updateWeightTree() {
        log.debug("begin to updateWeightTree...");
        int timeOut = this.rpcClient.getRpcClientOptions().getReadTimeoutMillis();
        LinkedList<Node> leafNodes = new LinkedList<Node>();
        if (CollectionUtils.isEmpty(this.rpcClient.getHealthyInstances())) {
            return;
        }
        LinkedList<BrpcChannel> fullWindowInstances = new LinkedList<BrpcChannel>();
        for (BrpcChannel group : this.rpcClient.getHealthyInstances()) {
            Queue<Integer> window = group.getLatencyWindow();
            if (window.size() != this.latencyWindowSize) continue;
            fullWindowInstances.add(group);
        }
        if (fullWindowInstances.size() < this.minInstancesNum || (double)fullWindowInstances.size() * 1.0 / (double)this.rpcClient.getHealthyInstances().size() < (double)this.activeInstancesRatio) {
            this.treeContainer = new CopyOnWriteArrayList();
            this.invalidInstances = new CopyOnWriteArrayList();
            return;
        }
        for (BrpcChannel group : fullWindowInstances) {
            int weight = this.calculateWeight(group, timeOut);
            leafNodes.add(new Node(group.hashCode(), weight, true, group));
        }
        Node root = this.generateWeightTreeByLeafNodes(leafNodes);
        this.treeContainer.add(0, root);
        while (this.treeContainer.size() > 1) {
            this.treeContainer.remove(1);
        }
        this.invalidInstances = new CopyOnWriteArrayList();
    }

    protected int calculateWeight(BrpcChannel group, int timeOut) {
        Queue<Integer> window = group.getLatencyWindow();
        int avgLatency = 0;
        Iterator iterator = window.iterator();
        while (iterator.hasNext()) {
            int latency = (Integer)iterator.next();
            avgLatency += latency;
        }
        avgLatency /= window.size();
        int weight = 100 - (avgLatency = avgLatency * 100 / (timeOut + 10));
        return weight > 0 ? weight : 1;
    }

    protected Node generateWeightTreeByLeafNodes(Queue<Node> leafNodes) {
        LinkedList<Node> nodes = new LinkedList<Node>(leafNodes);
        if (leafNodes.size() % 2 == 1) {
            nodes.add(Node.none);
        }
        Node root = new Node();
        while (nodes.size() > 0) {
            Node left = (Node)nodes.poll();
            Node right = (Node)nodes.poll();
            if (!left.isLeaf && right == null) {
                root = left;
                break;
            }
            Node parent = new Node(0, 0, false);
            parent.left = left;
            left.parent = parent;
            if (right != null && right != Node.none) {
                parent.right = right;
                parent.weight = left.weight + right.weight;
                right.parent = parent;
            } else {
                parent.weight = left.weight;
            }
            nodes.add(parent);
        }
        return root;
    }

    static class Node {
        static Node none = new Node();
        int serverId;
        int weight;
        boolean isLeaf;
        Node parent;
        Node left;
        Node right;
        BrpcChannel server;

        public Node() {
        }

        public Node(int serverId, int weight, boolean isLeaf) {
            this.serverId = serverId;
            this.weight = weight;
            this.isLeaf = isLeaf;
        }

        public Node(int serverId, int weight, boolean isLeaf, BrpcChannel server) {
            this.serverId = serverId;
            this.weight = weight;
            this.isLeaf = isLeaf;
            this.server = server;
        }
    }
}

