/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.storage.queue.support.converter;

import com.azure.core.util.BinaryData;
import com.azure.spring.messaging.converter.AbstractAzureMessageConverter;
import com.azure.spring.messaging.implementation.converter.ObjectMapperHolder;
import com.azure.storage.queue.models.QueueMessageItem;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;

public class StorageQueueMessageConverter
extends AbstractAzureMessageConverter<QueueMessageItem, QueueMessageItem> {
    private final ObjectMapper objectMapper;

    public StorageQueueMessageConverter() {
        this(ObjectMapperHolder.OBJECT_MAPPER);
    }

    public StorageQueueMessageConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected byte[] getPayload(QueueMessageItem azureMessage) {
        return azureMessage.getBody().toBytes();
    }

    protected QueueMessageItem fromString(String payload) {
        QueueMessageItem queueMessageItem = new QueueMessageItem();
        queueMessageItem.setBody(BinaryData.fromString((String)payload));
        return queueMessageItem;
    }

    protected QueueMessageItem fromByte(byte[] payload) {
        QueueMessageItem queueMessageItem = new QueueMessageItem();
        queueMessageItem.setBody(BinaryData.fromString((String)new String(payload, StandardCharsets.UTF_8)));
        return queueMessageItem;
    }
}

