/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.storage.queue.core.properties;

import com.azure.spring.cloud.core.implementation.properties.AzureHttpSdkProperties;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientProperties;
import com.azure.storage.queue.QueueMessageEncoding;
import com.azure.storage.queue.QueueServiceVersion;

public class StorageQueueProperties
extends AzureHttpSdkProperties
implements QueueServiceClientProperties {
    private static final String QUEUE_ENDPOINT_PATTERN = "https://%s.queue%s";
    private String endpoint;
    private String accountKey;
    private String sasToken;
    private String connectionString;
    private String accountName;
    private QueueServiceVersion serviceVersion;
    private QueueMessageEncoding messageEncoding;

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getEndpoint() {
        return this.endpoint == null ? this.buildEndpointFromAccountName() : this.endpoint;
    }

    private String buildEndpointFromAccountName() {
        return String.format(QUEUE_ENDPOINT_PATTERN, this.accountName, this.getProfile().getEnvironment().getStorageEndpointSuffix());
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountKey() {
        return this.accountKey;
    }

    public void setAccountKey(String accountKey) {
        this.accountKey = accountKey;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(QueueServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public QueueMessageEncoding getMessageEncoding() {
        return this.messageEncoding;
    }

    public void setMessageEncoding(QueueMessageEncoding messageEncoding) {
        this.messageEncoding = messageEncoding;
    }
}

