/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core.properties;

import com.azure.spring.cloud.core.implementation.connectionstring.ServiceBusConnectionString;
import com.azure.spring.cloud.core.implementation.properties.AzureAmqpSdkProperties;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusClientCommonProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;

public class CommonProperties
extends AzureAmqpSdkProperties
implements ServiceBusClientCommonProperties {
    private String domainName;
    private String namespace;
    private String connectionString;
    private String entityName;
    private ServiceBusEntityType entityType;

    private String extractFqdnFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new ServiceBusConnectionString(this.connectionString).getFullyQualifiedNamespace();
    }

    private String buildFqdnFromNamespace() {
        if (this.namespace == null || this.getDomainName() == null) {
            return null;
        }
        return this.namespace + "." + this.getDomainName();
    }

    public String getFullyQualifiedNamespace() {
        return this.namespace == null ? this.extractFqdnFromConnectionString() : this.buildFqdnFromNamespace();
    }

    public String getDomainName() {
        return this.domainName == null ? this.getProfile().getEnvironment().getServiceBusDomainName() : this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public ServiceBusEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ServiceBusEntityType entityType) {
        this.entityType = entityType;
    }
}

