/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.messaging.servicebus.core;

import com.azure.core.credential.TokenCredential;
import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.servicebus.factory.ServiceBusSenderClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.servicebus.properties.ServiceBusSenderClientProperties;
import com.azure.spring.cloud.service.servicebus.properties.ServiceBusEntityType;
import com.azure.spring.messaging.PropertiesSupplier;
import com.azure.spring.messaging.implementation.config.AzureMessagingBootstrapConfiguration;
import com.azure.spring.messaging.servicebus.core.ServiceBusProducerFactory;
import com.azure.spring.messaging.servicebus.core.properties.NamespaceProperties;
import com.azure.spring.messaging.servicebus.core.properties.ProducerProperties;
import com.azure.spring.messaging.servicebus.implementation.properties.merger.SenderPropertiesParentMerger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.lang.Nullable;

public final class DefaultServiceBusNamespaceProducerFactory
implements ServiceBusProducerFactory,
DisposableBean {
    private final List<ServiceBusProducerFactory.Listener> listeners = new ArrayList<ServiceBusProducerFactory.Listener>();
    private final NamespaceProperties namespaceProperties;
    private final PropertiesSupplier<String, ProducerProperties> propertiesSupplier;
    private final Map<String, ServiceBusSenderAsyncClient> clients = new ConcurrentHashMap<String, ServiceBusSenderAsyncClient>();
    private final SenderPropertiesParentMerger parentMerger = new SenderPropertiesParentMerger();
    private final List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> customizers = new ArrayList<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>>();
    private final Map<String, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>>> dedicatedCustomizers = new HashMap<String, List<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>>>();
    private AzureCredentialResolver<TokenCredential> tokenCredentialResolver = null;
    private TokenCredential defaultCredential = null;

    public DefaultServiceBusNamespaceProducerFactory(NamespaceProperties namespaceProperties) {
        this(namespaceProperties, (PropertiesSupplier<String, ProducerProperties>)((PropertiesSupplier)key -> null));
    }

    public DefaultServiceBusNamespaceProducerFactory(NamespaceProperties namespaceProperties, PropertiesSupplier<String, ProducerProperties> supplier) {
        this.namespaceProperties = namespaceProperties;
        this.propertiesSupplier = supplier == null ? key -> null : supplier;
    }

    @Override
    public ServiceBusSenderAsyncClient createProducer(String name) {
        return this.createProducer(name, null);
    }

    @Override
    public ServiceBusSenderAsyncClient createProducer(String name, ServiceBusEntityType entityType) {
        ProducerProperties producerProperties;
        ProducerProperties producerProperties2 = producerProperties = this.propertiesSupplier.getProperties((Object)name) != null ? (ProducerProperties)((Object)this.propertiesSupplier.getProperties((Object)name)) : new ProducerProperties();
        if (entityType != null) {
            producerProperties.setEntityType(entityType);
        }
        return this.doCreateProducer(name, producerProperties);
    }

    @Override
    public void addListener(ServiceBusProducerFactory.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ServiceBusProducerFactory.Listener listener) {
        return this.listeners.remove(listener);
    }

    public void destroy() {
        this.clients.forEach((name, producer) -> {
            this.listeners.forEach(l -> l.producerRemoved((String)name, (ServiceBusSenderAsyncClient)producer));
            producer.close();
        });
        this.clients.clear();
        this.listeners.clear();
    }

    private ServiceBusSenderAsyncClient doCreateProducer(String name, @Nullable ProducerProperties properties) {
        return this.clients.computeIfAbsent(name, entityName -> {
            ProducerProperties producerProperties = this.parentMerger.merge(properties, this.namespaceProperties);
            producerProperties.setEntityName((String)entityName);
            ServiceBusSenderClientBuilderFactory factory = new ServiceBusSenderClientBuilderFactory((ServiceBusSenderClientProperties)producerProperties);
            factory.setDefaultTokenCredential(this.defaultCredential);
            factory.setTokenCredentialResolver(this.tokenCredentialResolver);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_INTEGRATION_SERVICE_BUS);
            ServiceBusClientBuilder.ServiceBusSenderClientBuilder builder = (ServiceBusClientBuilder.ServiceBusSenderClientBuilder)factory.build();
            this.customizeBuilder(name, builder);
            ServiceBusSenderAsyncClient producerClient = builder.buildAsyncClient();
            this.listeners.forEach(l -> l.producerAdded((String)entityName, producerClient));
            return producerClient;
        });
    }

    public void setTokenCredentialResolver(AzureCredentialResolver<TokenCredential> tokenCredentialResolver) {
        this.tokenCredentialResolver = tokenCredentialResolver;
    }

    public void setDefaultCredential(TokenCredential defaultCredential) {
        this.defaultCredential = defaultCredential;
    }

    public void addBuilderCustomizer(AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder> customizer) {
        if (customizer == null) {
            AzureMessagingBootstrapConfiguration.LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.customizers.add(customizer);
    }

    public void addBuilderCustomizer(String entityName, AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder> customizer) {
        if (customizer == null) {
            AzureMessagingBootstrapConfiguration.LOGGER.debug("The provided customizer is null, will ignore it.");
            return;
        }
        this.dedicatedCustomizers.computeIfAbsent(entityName, key -> new ArrayList()).add(customizer);
    }

    private void customizeBuilder(String entityName, ServiceBusClientBuilder.ServiceBusSenderClientBuilder builder) {
        this.customizers.forEach(customizer -> customizer.customize((Object)builder));
        ((List)this.dedicatedCustomizers.getOrDefault(entityName, new ArrayList())).forEach(customizer -> customizer.customize((Object)builder));
    }
}

