/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.stream.binder.eventhubs.core.properties;

import com.azure.spring.cloud.service.implementation.core.PropertiesValidator;
import com.azure.spring.cloud.stream.binder.eventhubs.core.properties.EventHubsBindingProperties;
import com.azure.spring.cloud.stream.binder.eventhubs.core.properties.EventHubsConsumerProperties;
import com.azure.spring.cloud.stream.binder.eventhubs.core.properties.EventHubsProducerProperties;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.AbstractExtendedBindingProperties;
import org.springframework.cloud.stream.binder.BinderSpecificPropertiesProvider;

@ConfigurationProperties(value="spring.cloud.stream.eventhubs")
public class EventHubsExtendedBindingProperties
extends AbstractExtendedBindingProperties<EventHubsConsumerProperties, EventHubsProducerProperties, EventHubsBindingProperties>
implements InitializingBean {
    public static final String PREFIX = "spring.cloud.stream.eventhubs";
    private static final String DEFAULTS_PREFIX = "spring.cloud.stream.eventhubs.default";
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHubsExtendedBindingProperties.class);

    public String getDefaultsPrefix() {
        return DEFAULTS_PREFIX;
    }

    public Class<? extends BinderSpecificPropertiesProvider> getExtendedPropertiesEntryClass() {
        return EventHubsBindingProperties.class;
    }

    public Map<String, EventHubsBindingProperties> getBindings() {
        return this.doGetBindings();
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.validateNamespaceProperties();
        }
        catch (IllegalArgumentException exception) {
            LOGGER.warn(exception.getMessage());
        }
    }

    private void validateNamespaceProperties() {
        this.getBindings().values().stream().map(bindings -> bindings.getConsumer().getNamespace()).filter(Objects::nonNull).forEach(PropertiesValidator::validateNamespace);
        this.getBindings().values().stream().map(bindings -> bindings.getProducer().getNamespace()).filter(Objects::nonNull).forEach(PropertiesValidator::validateNamespace);
    }
}

