/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.passwordless;

import com.azure.spring.cloud.core.properties.PasswordlessProperties;
import com.azure.spring.cloud.core.properties.authentication.TokenCredentialProperties;
import com.azure.spring.cloud.core.properties.profile.AzureProfileProperties;
import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import java.util.HashMap;
import java.util.Map;

public class AzureJdbcPasswordlessProperties
implements PasswordlessProperties {
    private static final String JDBC_SCOPE_AZURE = "https://ossrdbms-aad.database.windows.net/.default";
    private static final String JDBC_SCOPE_AZURE_CHINA = "https://ossrdbms-aad.database.chinacloudapi.cn/.default";
    private static final String JDBC_SCOPE_AZURE_GERMANY = "https://ossrdbms-aad.database.cloudapi.de/.default";
    private static final String JDBC_SCOPE_AZURE_US_GOVERNMENT = "https://ossrdbms-aad.database.usgovcloudapi.net/.default";
    private static final Map<AzureProfileOptionsProvider.CloudType, String> JDBC_SCOPE_MAP = new HashMap<AzureProfileOptionsProvider.CloudType, String>(){
        {
            this.put(AzureProfileOptionsProvider.CloudType.AZURE, AzureJdbcPasswordlessProperties.JDBC_SCOPE_AZURE);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_CHINA, AzureJdbcPasswordlessProperties.JDBC_SCOPE_AZURE_CHINA);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_GERMANY, AzureJdbcPasswordlessProperties.JDBC_SCOPE_AZURE_GERMANY);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_US_GOVERNMENT, AzureJdbcPasswordlessProperties.JDBC_SCOPE_AZURE_US_GOVERNMENT);
        }
    };
    private boolean passwordlessEnabled = false;
    private AzureProfileProperties profile = new AzureProfileProperties();
    private String scopes;
    private TokenCredentialProperties credential = new TokenCredentialProperties();

    public String getScopes() {
        return this.scopes == null ? this.getDefaultScopes() : this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public boolean isPasswordlessEnabled() {
        return this.passwordlessEnabled;
    }

    public void setPasswordlessEnabled(boolean passwordlessEnabled) {
        this.passwordlessEnabled = passwordlessEnabled;
    }

    private String getDefaultScopes() {
        return JDBC_SCOPE_MAP.getOrDefault(this.getProfile().getCloudType(), JDBC_SCOPE_AZURE);
    }

    public AzureProfileProperties getProfile() {
        return this.profile;
    }

    public void setProfile(AzureProfileProperties profile) {
        this.profile = profile;
    }

    public TokenCredentialProperties getCredential() {
        return this.credential;
    }

    public void setCredential(TokenCredentialProperties credential) {
        this.credential = credential;
    }
}

