/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.kafka;

import com.azure.core.credential.AccessToken;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;

public class AzureOAuthBearerToken
implements OAuthBearerToken {
    private final AccessToken accessToken;
    private final JWTClaimsSet claims;

    public AzureOAuthBearerToken(AccessToken accessToken) {
        this.accessToken = accessToken;
        try {
            this.claims = JWTParser.parse((String)accessToken.getToken()).getJWTClaimsSet();
        }
        catch (ParseException exception) {
            throw new SaslAuthenticationException("Unable to parse the access token", (Throwable)exception);
        }
    }

    public String value() {
        return this.accessToken.getToken();
    }

    public Long startTimeMs() {
        return this.claims.getIssueTime().getTime();
    }

    public long lifetimeMs() {
        return this.claims.getExpirationTime().getTime();
    }

    public Set<String> scope() {
        return Optional.ofNullable(this.claims.getClaim("scp")).map(s -> Arrays.stream(((String)s).split(" ")).collect(Collectors.toSet())).orElse(null);
    }

    public String principalName() {
        return (String)this.claims.getClaim("upn");
    }

    public boolean isExpired() {
        return this.accessToken.isExpired();
    }
}

