/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.passwordless;

import com.azure.spring.cloud.core.provider.AzureProfileOptionsProvider;
import com.azure.spring.cloud.service.implementation.passwordless.AzurePasswordlessProperties;
import java.util.HashMap;
import java.util.Map;

public class AzureRedisPasswordlessProperties
extends AzurePasswordlessProperties {
    private static final String REDIS_SCOPE_AZURE = "https://*.cacheinfra.windows.net:10225/appid/.default";
    private static final String REDIS_SCOPE_AZURE_CHINA = "https://*.cacheinfra.windows.net.china:10225/appid/.default";
    private static final String REDIS_SCOPE_AZURE_GERMANY = "https://*.cacheinfra.windows.net.germany:10225/appid/.default";
    private static final String REDIS_SCOPE_AZURE_US_GOVERNMENT = "https://*.cacheinfra.windows.us.government.net:10225/appid/.default";
    private static final Map<AzureProfileOptionsProvider.CloudType, String> REDIS_SCOPE_MAP = new HashMap<AzureProfileOptionsProvider.CloudType, String>(){
        {
            this.put(AzureProfileOptionsProvider.CloudType.AZURE, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_CHINA, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE_CHINA);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_GERMANY, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE_GERMANY);
            this.put(AzureProfileOptionsProvider.CloudType.AZURE_US_GOVERNMENT, AzureRedisPasswordlessProperties.REDIS_SCOPE_AZURE_US_GOVERNMENT);
        }
    };

    @Override
    public String getScopes() {
        return super.getScopes() == null ? this.getRedisScopes() : super.getScopes();
    }

    private String getRedisScopes() {
        return REDIS_SCOPE_MAP.getOrDefault(this.getProfile().getCloudType(), REDIS_SCOPE_AZURE);
    }
}

