/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.passwordless;

import com.azure.identity.extensions.implementation.enums.AuthProperty;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.properties.authentication.TokenCredentialProperties;
import com.azure.spring.cloud.core.properties.client.ClientProperties;
import com.azure.spring.cloud.core.properties.profile.AzureProfileProperties;
import com.azure.spring.cloud.core.properties.proxy.ProxyProperties;
import com.azure.spring.cloud.core.provider.ClientOptionsProvider;
import com.azure.spring.cloud.core.provider.ProxyOptionsProvider;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class AzurePasswordlessProperties
implements AzureProperties {
    private AzureProfileProperties profile = new AzureProfileProperties();
    private String scopes;
    private TokenCredentialProperties credential = new TokenCredentialProperties();
    private ClientProperties client = new ClientProperties();
    private ProxyProperties proxy = new ProxyProperties();
    private boolean passwordlessEnabled = false;

    public AzureProfileProperties getProfile() {
        return this.profile;
    }

    public void setProfile(AzureProfileProperties profile) {
        this.profile = profile;
    }

    public TokenCredentialProperties getCredential() {
        return this.credential;
    }

    public void setCredential(TokenCredentialProperties credential) {
        this.credential = credential;
    }

    public ClientOptionsProvider.ClientOptions getClient() {
        return this.client;
    }

    public void setClient(ClientProperties client) {
        this.client = client;
    }

    public ProxyOptionsProvider.ProxyOptions getProxy() {
        return this.proxy;
    }

    public void setProxy(ProxyProperties proxy) {
        this.proxy = proxy;
    }

    public boolean isPasswordlessEnabled() {
        return this.passwordlessEnabled;
    }

    public void setPasswordlessEnabled(boolean passwordlessEnabled) {
        this.passwordlessEnabled = passwordlessEnabled;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public Properties toProperties() {
        Properties target = new Properties();
        for (AzurePasswordlessPropertiesMapping m : AzurePasswordlessPropertiesMapping.values()) {
            if (m.getter.apply(this) == null) continue;
            m.setter.accept(target, (String)m.getter.apply(this));
        }
        return target;
    }

    private static enum AzurePasswordlessPropertiesMapping {
        scopes(p -> p.getScopes(), (p, s) -> p.setProperty(AuthProperty.SCOPES.getPropertyKey(), (String)s)),
        clientCertificatePassword(p -> p.getCredential().getClientCertificatePassword(), (p, s) -> p.setProperty(AuthProperty.CLIENT_CERTIFICATE_PASSWORD.getPropertyKey(), (String)s)),
        clientCertificatePath(p -> p.getCredential().getClientCertificatePath(), (p, s) -> p.setProperty(AuthProperty.CLIENT_CERTIFICATE_PATH.getPropertyKey(), (String)s)),
        clientId(p -> p.getCredential().getClientId(), (p, s) -> p.setProperty(AuthProperty.CLIENT_ID.getPropertyKey(), (String)s)),
        clientSecret(p -> p.getCredential().getClientSecret(), (p, s) -> p.setProperty(AuthProperty.CLIENT_SECRET.getPropertyKey(), (String)s)),
        managedIdentityEnabled(p -> String.valueOf(p.getCredential().isManagedIdentityEnabled()), (p, s) -> p.setProperty(AuthProperty.MANAGED_IDENTITY_ENABLED.getPropertyKey(), (String)s)),
        password(p -> p.getCredential().getPassword(), (p, s) -> p.setProperty(AuthProperty.PASSWORD.getPropertyKey(), (String)s)),
        username(p -> p.getCredential().getUsername(), (p, s) -> p.setProperty(AuthProperty.USERNAME.getPropertyKey(), (String)s)),
        tenantId(p -> p.getProfile().getTenantId(), (p, s) -> p.setProperty(AuthProperty.TENANT_ID.getPropertyKey(), (String)s)),
        authorityHost(p -> p.getProfile().getEnvironment().getActiveDirectoryEndpoint(), (p, s) -> p.setProperty(AuthProperty.AUTHORITY_HOST.getPropertyKey(), (String)s));

        private Function<AzurePasswordlessProperties, String> getter;
        private BiConsumer<Properties, String> setter;

        private AzurePasswordlessPropertiesMapping(Function<AzurePasswordlessProperties, String> getter, BiConsumer<Properties, String> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        public Function<AzurePasswordlessProperties, String> getter() {
            return this.getter;
        }

        public BiConsumer<Properties, String> setter() {
            return this.setter;
        }
    }
}

