/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.service.implementation.jaas;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.Assert;

public class Jaas {
    public static final String DELIMITER = " ";
    public static final String TERMINATOR = ";";
    private String loginModule;
    private ControlFlag controlFlag;
    private Map<String, String> options;

    public Jaas(String loginModule) {
        this(loginModule, ControlFlag.REQUIRED);
    }

    public Jaas(String loginModule, ControlFlag controlFlag) {
        this(loginModule, controlFlag, new HashMap<String, String>());
    }

    public Jaas(String loginModule, ControlFlag controlFlag, Map<String, String> options) {
        Assert.hasText((String)loginModule, (String)"The login module of JAAS should not be null or empty");
        Assert.notNull((Object)((Object)controlFlag), (String)"The control flag of JAAS should not be null");
        this.loginModule = loginModule;
        this.controlFlag = controlFlag;
        this.options = options == null ? new HashMap() : options;
    }

    public String getLoginModule() {
        return this.loginModule;
    }

    public void setLoginModule(String loginModule) {
        this.loginModule = loginModule;
    }

    public ControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public void setControlFlag(ControlFlag controlFlag) {
        this.controlFlag = controlFlag;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public void putOptions(Map<String, String> options) {
        if (options != null) {
            this.options.putAll(options);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.loginModule).append(DELIMITER).append(this.controlFlag.name().toLowerCase(Locale.ROOT));
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            builder.append(DELIMITER).append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        return builder.append(TERMINATOR).toString();
    }

    public static enum ControlFlag {
        REQUIRED,
        REQUISITE,
        SUFFICIENT,
        OPTIONAL;

        private static final Map<String, ControlFlag> CONTROL_FLAG_MAP;

        private static Map<String, ControlFlag> initMap() {
            return Collections.unmodifiableMap(Arrays.stream(ControlFlag.values()).collect(Collectors.toMap(f -> f.name(), Function.identity())));
        }

        public static ControlFlag fromString(String value) {
            return CONTROL_FLAG_MAP.get(value.toUpperCase(Locale.ROOT));
        }

        static {
            CONTROL_FLAG_MAP = ControlFlag.initMap();
        }
    }
}

