/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.AbstractAzureStorageProtocolResolver;
import com.azure.spring.cloud.core.resource.StorageFileResource;
import com.azure.spring.cloud.core.resource.StorageType;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.models.ListSharesOptions;
import com.azure.storage.file.share.models.ShareItem;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;

public final class AzureStorageFileProtocolResolver
extends AbstractAzureStorageProtocolResolver {
    private ShareServiceClient shareServiceClient;

    @Override
    protected StorageType getStorageType() {
        return StorageType.FILE;
    }

    @Override
    protected Stream<AbstractAzureStorageProtocolResolver.StorageContainerItem> listStorageContainers(String containerPrefix) {
        ListSharesOptions options = new ListSharesOptions();
        options.setPrefix(containerPrefix);
        options.setIncludeDeleted(false);
        options.setIncludeMetadata(false);
        options.setIncludeSnapshots(false);
        return this.getShareServiceClient().listShares(options, null, null).stream().map(ShareItem::getName).map(AbstractAzureStorageProtocolResolver.StorageContainerItem::new);
    }

    @Override
    protected AbstractAzureStorageProtocolResolver.StorageContainerClient getStorageContainerClient(String name) {
        return new StorageFileContainerClient(name);
    }

    @Override
    protected Resource getStorageResource(String location, Boolean autoCreate) {
        return new StorageFileResource(this.getShareServiceClient(), location, autoCreate);
    }

    private ShareServiceClient getShareServiceClient() {
        if (this.shareServiceClient == null) {
            this.shareServiceClient = (ShareServiceClient)this.beanFactory.getBean(ShareServiceClient.class);
        }
        return this.shareServiceClient;
    }

    private class StorageFileContainerClient
    implements AbstractAzureStorageProtocolResolver.StorageContainerClient {
        private final String name;

        StorageFileContainerClient(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Stream<AbstractAzureStorageProtocolResolver.StorageItem> listItems(String itemPrefix) {
            ShareClient shareClient = AzureStorageFileProtocolResolver.this.getShareServiceClient().getShareClient(this.name);
            if (shareClient.exists().booleanValue()) {
                return shareClient.getRootDirectoryClient().listFilesAndDirectories(itemPrefix, null, null, null).stream().filter(file -> !file.isDirectory()).map(file -> new AbstractAzureStorageProtocolResolver.StorageItem(this.name, file.getName(), AzureStorageFileProtocolResolver.this.getStorageType()));
            }
            return Stream.empty();
        }
    }
}

