/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.factory.credential;

import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.spring.cloud.core.implementation.factory.credential.AbstractAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.properties.PropertyMapper;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;

public class ManagedIdentityCredentialBuilderFactory
extends AbstractAzureCredentialBuilderFactory<ManagedIdentityCredentialBuilder> {
    public ManagedIdentityCredentialBuilderFactory(AzureProperties azureProperties) {
        super(azureProperties);
    }

    @Override
    protected ManagedIdentityCredentialBuilder createBuilderInstance() {
        return new ManagedIdentityCredentialBuilder();
    }

    @Override
    protected void configureService(ManagedIdentityCredentialBuilder builder) {
        super.configureService(builder);
        AzureProperties azureProperties = this.getAzureProperties();
        TokenCredentialOptionsProvider.TokenCredentialOptions credential = azureProperties.getCredential();
        PropertyMapper map = new PropertyMapper();
        map.from(credential.getClientId()).when(p -> credential.isManagedIdentityEnabled()).to(arg_0 -> ((ManagedIdentityCredentialBuilder)builder).clientId(arg_0));
    }
}

