/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.AbstractAzureStorageProtocolResolver;
import com.azure.spring.cloud.core.resource.StorageBlobResource;
import com.azure.spring.cloud.core.resource.StorageType;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobContainerListDetails;
import com.azure.storage.blob.models.BlobListDetails;
import com.azure.storage.blob.models.ListBlobContainersOptions;
import com.azure.storage.blob.models.ListBlobsOptions;
import java.util.stream.Stream;
import org.springframework.core.io.Resource;

public final class AzureStorageBlobProtocolResolver
extends AbstractAzureStorageProtocolResolver {
    private BlobServiceClient blobServiceClient;
    private static final BlobListDetails RETRIEVE_NOTHING_DETAILS = new BlobListDetails();
    private static final BlobContainerListDetails RETRIEVE_NOTHING_CONTAINER_DETAILS = new BlobContainerListDetails();

    @Override
    protected StorageType getStorageType() {
        return StorageType.BLOB;
    }

    @Override
    protected Stream<AbstractAzureStorageProtocolResolver.StorageContainerItem> listStorageContainers(String containerPrefix) {
        ListBlobContainersOptions options = new ListBlobContainersOptions();
        options.setPrefix(containerPrefix);
        options.setDetails(RETRIEVE_NOTHING_CONTAINER_DETAILS);
        return this.getBlobServiceClient().listBlobContainers(options, null).stream().map(BlobContainerItem::getName).map(AbstractAzureStorageProtocolResolver.StorageContainerItem::new);
    }

    @Override
    protected AbstractAzureStorageProtocolResolver.StorageContainerClient getStorageContainerClient(String name) {
        return new StorageBlobContainerClient(name);
    }

    @Override
    protected Resource getStorageResource(String location, Boolean autoCreate) {
        return new StorageBlobResource(this.getBlobServiceClient(), location, autoCreate);
    }

    private BlobServiceClient getBlobServiceClient() {
        if (this.blobServiceClient == null) {
            this.blobServiceClient = (BlobServiceClient)this.beanFactory.getBean(BlobServiceClient.class);
        }
        return this.blobServiceClient;
    }

    static {
        RETRIEVE_NOTHING_DETAILS.setRetrieveCopy(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveDeletedBlobs(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveDeletedBlobsWithVersions(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveImmutabilityPolicy(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveMetadata(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveLegalHold(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveSnapshots(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveTags(false);
        RETRIEVE_NOTHING_DETAILS.setRetrieveUncommittedBlobs(false);
        RETRIEVE_NOTHING_CONTAINER_DETAILS.setRetrieveMetadata(false);
        RETRIEVE_NOTHING_CONTAINER_DETAILS.setRetrieveDeleted(false);
    }

    private class StorageBlobContainerClient
    implements AbstractAzureStorageProtocolResolver.StorageContainerClient {
        private final String name;

        StorageBlobContainerClient(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Stream<AbstractAzureStorageProtocolResolver.StorageItem> listItems(String itemPrefix) {
            ListBlobsOptions options = new ListBlobsOptions();
            options.setPrefix(itemPrefix);
            options.setDetails(RETRIEVE_NOTHING_DETAILS);
            BlobContainerClient containerClient = AzureStorageBlobProtocolResolver.this.getBlobServiceClient().getBlobContainerClient(this.name);
            if (containerClient.exists()) {
                return containerClient.listBlobs(options, null).stream().map(blob -> new AbstractAzureStorageProtocolResolver.StorageItem(this.name, blob.getName(), AzureStorageBlobProtocolResolver.this.getStorageType()));
            }
            return Stream.empty();
        }
    }
}

