/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.resource;

import com.azure.spring.cloud.core.resource.AzureStorageUtils;
import com.azure.spring.cloud.core.resource.StorageType;
import java.io.IOException;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;

public abstract class AbstractAzureStorageProtocolResolver
implements ProtocolResolver,
ResourcePatternResolver,
ResourceLoaderAware,
BeanFactoryPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAzureStorageProtocolResolver.class);
    protected final AntPathMatcher matcher = new AntPathMatcher();
    protected ConfigurableListableBeanFactory beanFactory;

    protected abstract StorageType getStorageType();

    protected abstract Resource getStorageResource(String var1, Boolean var2);

    protected abstract Stream<StorageContainerItem> listStorageContainers(String var1);

    protected abstract StorageContainerClient getStorageContainerClient(String var1);

    public void setResourceLoader(ResourceLoader resourceLoader) {
        if (resourceLoader instanceof DefaultResourceLoader) {
            ((DefaultResourceLoader)resourceLoader).addProtocolResolver((ProtocolResolver)this);
        } else {
            LOGGER.warn("Custom Protocol using azure-{}:// prefix will not be enabled.", (Object)this.getStorageType().getType());
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        if (AzureStorageUtils.isAzureStorageResource(location, this.getStorageType())) {
            return this.getResource(location);
        }
        return null;
    }

    public Resource[] getResources(String pattern) throws IOException {
        Resource[] resources = null;
        if (AzureStorageUtils.isAzureStorageResource(pattern, this.getStorageType())) {
            if (this.matcher.isPattern(AzureStorageUtils.stripProtocol(pattern, this.getStorageType()))) {
                String containerPattern = AzureStorageUtils.getContainerName(pattern, this.getStorageType());
                String filePattern = AzureStorageUtils.getFilename(pattern, this.getStorageType());
                resources = this.resolveResources(containerPattern, filePattern);
            } else {
                return new Resource[]{this.getResource(pattern)};
            }
        }
        if (null == resources) {
            throw new IOException("Resources not found at " + pattern);
        }
        return resources;
    }

    public Resource getResource(String location) {
        Resource resource = null;
        if (AzureStorageUtils.isAzureStorageResource(location, this.getStorageType())) {
            resource = this.getStorageResource(location, true);
        }
        if (null == resource) {
            throw new IllegalArgumentException("Resource not found at " + location);
        }
        return resource;
    }

    public ClassLoader getClassLoader() {
        return ClassUtils.getDefaultClassLoader();
    }

    protected Resource[] resolveResources(String containerPattern, String itemPattern) {
        return (Resource[])this.getMatchedContainers(containerPattern).flatMap(c -> this.getMatchedItems((StorageContainerClient)c, itemPattern)).map(s -> this.getStorageResource(s.toResourceLocation(), false)).toArray(Resource[]::new);
    }

    protected Stream<StorageContainerClient> getMatchedContainers(String pattern) {
        if (this.matcher.isPattern(pattern)) {
            return this.listStorageContainers(this.getValidPrefix(pattern)).filter(i -> this.matcher.match(pattern, i.getName())).map(i -> this.getStorageContainerClient(i.getName()));
        }
        return Stream.of(this.getStorageContainerClient(pattern));
    }

    protected Stream<StorageItem> getMatchedItems(StorageContainerClient containerClient, String itemPattern) {
        if (this.matcher.isPattern(itemPattern)) {
            return containerClient.listItems(this.getValidPrefix(itemPattern)).filter(item -> this.matcher.match(itemPattern, item.getName()));
        }
        return Stream.of(new StorageItem(containerClient.getName(), itemPattern, this.getStorageType()));
    }

    private String getValidPrefix(String keyPattern) {
        int starIndex = keyPattern.indexOf("*");
        int markIndex = keyPattern.indexOf("?");
        int index = Math.min(starIndex == -1 ? keyPattern.length() : starIndex, markIndex == -1 ? keyPattern.length() : markIndex);
        return keyPattern.substring(0, index);
    }

    protected static interface StorageContainerClient {
        public String getName();

        public Stream<StorageItem> listItems(String var1);
    }

    protected static class StorageItem {
        private final String container;
        private final String name;
        private final StorageType storageType;

        public StorageItem(String container, String fileName, StorageType storageType) {
            this.container = container;
            this.name = fileName;
            this.storageType = storageType;
        }

        public String getContainer() {
            return this.container;
        }

        public String getName() {
            return this.name;
        }

        public StorageType getStorageType() {
            return this.storageType;
        }

        public String toResourceLocation() {
            return AzureStorageUtils.getStorageProtocolPrefix(this.getStorageType()) + this.container + "/" + this.name;
        }
    }

    protected static class StorageContainerItem {
        private final String name;

        public StorageContainerItem(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

