/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.core.implementation.credential.resolver;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientCertificateCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientSecretCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ManagedIdentityCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.UsernamePasswordCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public class AzureTokenCredentialResolver
implements AzureCredentialResolver<TokenCredential> {
    private final Function<AzureProperties, TokenCredential> resolveFunction;

    public AzureTokenCredentialResolver(Function<AzureProperties, TokenCredential> resolveFunction) {
        this.resolveFunction = resolveFunction;
    }

    public AzureTokenCredentialResolver() {
        this.resolveFunction = AzureTokenCredentialResolver::resolveTokenCredential;
    }

    @Override
    public TokenCredential resolve(AzureProperties properties) {
        return this.resolveFunction.apply(properties);
    }

    private static TokenCredential resolveTokenCredential(AzureProperties azureProperties) {
        if (azureProperties.getCredential() == null) {
            return null;
        }
        TokenCredentialOptionsProvider.TokenCredentialOptions properties = azureProperties.getCredential();
        String tenantId = azureProperties.getProfile().getTenantId();
        String clientId = properties.getClientId();
        boolean isClientIdSet = StringUtils.hasText((String)clientId);
        if (StringUtils.hasText((String)tenantId)) {
            if (isClientIdSet && StringUtils.hasText((String)properties.getClientSecret())) {
                return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilderFactory(azureProperties).build()).clientId(clientId)).clientSecret(properties.getClientSecret()).tenantId(tenantId)).build();
            }
            String clientCertificatePath = properties.getClientCertificatePath();
            if (StringUtils.hasText((String)clientCertificatePath)) {
                ClientCertificateCredentialBuilder builder = (ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)new ClientCertificateCredentialBuilderFactory(azureProperties).build()).tenantId(tenantId)).clientId(clientId);
                if (StringUtils.hasText((String)properties.getClientCertificatePassword())) {
                    builder.pfxCertificate(clientCertificatePath, properties.getClientCertificatePassword());
                } else {
                    builder.pemCertificate(clientCertificatePath);
                }
                return builder.build();
            }
        }
        if (isClientIdSet && StringUtils.hasText((String)properties.getUsername()) && StringUtils.hasText((String)properties.getPassword())) {
            return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)new UsernamePasswordCredentialBuilderFactory(azureProperties).build()).username(properties.getUsername()).password(properties.getPassword()).clientId(clientId)).tenantId(tenantId)).build();
        }
        if (properties.isManagedIdentityEnabled()) {
            ManagedIdentityCredentialBuilder builder = (ManagedIdentityCredentialBuilder)new ManagedIdentityCredentialBuilderFactory(azureProperties).build();
            if (isClientIdSet) {
                builder.clientId(clientId);
            }
            return builder.build();
        }
        return null;
    }

    @Override
    public boolean isResolvable(AzureProperties properties) {
        return true;
    }
}

