/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets;

import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.cloud.autoconfigure.implementation.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.AzureKeyVaultConfiguration;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.common.AzureKeyVaultProperties;
import com.azure.spring.cloud.autoconfigure.implementation.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.utils.AzureServicePropertiesUtils;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.keyvault.secrets.SecretClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={SecretClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.keyvault.secret.enabled", "spring.cloud.azure.keyvault.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefixes={"spring.cloud.azure.keyvault.secret", "spring.cloud.azure.keyvault"}, name={"endpoint"})
@Import(value={AzureKeyVaultConfiguration.class})
public class AzureKeyVaultSecretAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.azure.keyvault.secret")
    AzureKeyVaultSecretProperties azureKeyVaultSecretProperties(AzureKeyVaultProperties azureKeyVaultProperties) {
        return AzureServicePropertiesUtils.loadServiceCommonProperties(azureKeyVaultProperties, new AzureKeyVaultSecretProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    SecretClient azureKeyVaultSecretClient(SecretClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    SecretAsyncClient azureKeyVaultSecretAsyncClient(SecretClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    SecretClientBuilder secretClientBuilder(SecretClientBuilderFactory factory) {
        return (SecretClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    SecretClientBuilderFactory secretClientBuilderFactory(AzureKeyVaultSecretProperties properties, ObjectProvider<AzureServiceClientBuilderCustomizer<SecretClientBuilder>> customizers) {
        SecretClientBuilderFactory factory = new SecretClientBuilderFactory((SecretClientProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_KEY_VAULT_SECRETS);
        customizers.orderedStream().forEach(arg_0 -> ((SecretClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

