/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.compatibility;

import com.azure.spring.cloud.autoconfigure.implementation.compatibility.AzureCompatibilityNotMetException;
import com.azure.spring.cloud.autoconfigure.implementation.compatibility.VerificationResult;
import java.util.List;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class AzureCompatibilityNotMetFailureAnalyzer
extends AbstractFailureAnalyzer<AzureCompatibilityNotMetException> {
    protected FailureAnalysis analyze(Throwable rootFailure, AzureCompatibilityNotMetException cause) {
        return new FailureAnalysis(this.getDescription(cause), this.getAction(cause), (Throwable)cause);
    }

    private String getDescription(AzureCompatibilityNotMetException ex) {
        return String.format("Your project setup is incompatible with our requirements due to following reasons:%s", this.descriptions(ex.getResults()));
    }

    private String descriptions(List<VerificationResult> results) {
        StringBuilder builder = new StringBuilder(System.lineSeparator());
        for (VerificationResult result : results) {
            builder.append("- ").append(result.getDescription()).append(System.lineSeparator());
        }
        return builder.toString();
    }

    private String getAction(AzureCompatibilityNotMetException ex) {
        return String.format("Consider applying the following actions:%s", this.actions(ex.getResults()));
    }

    private String actions(List<VerificationResult> results) {
        StringBuilder builder = new StringBuilder(System.lineSeparator());
        for (VerificationResult result : results) {
            builder.append("- ").append(result.getAction()).append(System.lineSeparator());
        }
        return builder.toString();
    }
}

