/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security;

import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.AadB2cAuthorizationRequestResolver;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.AadB2cLogoutSuccessHandler;
import com.azure.spring.cloud.autoconfigure.implementation.aadb2c.security.AadB2cOAuth2AuthorizationCodeGrantRequestEntityConverter;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.oauth2.client.endpoint.DefaultAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.client.RestOperations;

public class AadB2cOidcLoginConfigurer
extends AbstractHttpConfigurer<AadB2cOidcLoginConfigurer, HttpSecurity> {
    private final LogoutSuccessHandler handler;
    private final OAuth2AuthorizationRequestResolver resolver;
    private final OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient;
    private final RestTemplateBuilder restTemplateBuilder;

    public AadB2cOidcLoginConfigurer(AadB2cLogoutSuccessHandler handler, AadB2cAuthorizationRequestResolver resolver) {
        this((LogoutSuccessHandler)handler, resolver, null, null);
    }

    public AadB2cOidcLoginConfigurer(LogoutSuccessHandler handler, OAuth2AuthorizationRequestResolver resolver, OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient) {
        this(handler, resolver, accessTokenResponseClient, null);
    }

    public AadB2cOidcLoginConfigurer(LogoutSuccessHandler handler, OAuth2AuthorizationRequestResolver resolver, OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient, RestTemplateBuilder restTemplateBuilder) {
        this.handler = handler;
        this.resolver = resolver;
        this.accessTokenResponseClient = accessTokenResponseClient;
        this.restTemplateBuilder = restTemplateBuilder;
    }

    public void init(HttpSecurity http) throws Exception {
        http.logout(logout -> logout.logoutSuccessHandler(this.handler)).oauth2Login(oauth2 -> oauth2.authorizationEndpoint(authorization -> authorization.authorizationRequestResolver(this.resolver)).tokenEndpoint(token -> token.accessTokenResponseClient(this.accessTokenResponseClient())));
    }

    protected OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        if (this.accessTokenResponseClient != null) {
            return this.accessTokenResponseClient;
        }
        DefaultAuthorizationCodeTokenResponseClient client = new DefaultAuthorizationCodeTokenResponseClient();
        client.setRequestEntityConverter((Converter)new AadB2cOAuth2AuthorizationCodeGrantRequestEntityConverter());
        client.setRestOperations((RestOperations)AadRestTemplateCreator.createOAuth2AccessTokenResponseClientRestTemplate(this.restTemplateBuilder));
        return client;
    }
}

