/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.constants;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

public final class Constants {
    public static final String BEARER_PREFIX = "Bearer ";
    public static final String CONDITIONAL_ACCESS_POLICY_CLAIMS = "CONDITIONAL_ACCESS_POLICY_CLAIMS";
    public static final String CLAIMS = "claims";
    public static final Set<SimpleGrantedAuthority> DEFAULT_AUTHORITY_SET;
    public static final AuthorizationGrantType ON_BEHALF_OF;
    public static final AuthorizationGrantType AZURE_DELEGATED;

    private Constants() {
    }

    static {
        ON_BEHALF_OF = new AuthorizationGrantType("on_behalf_of");
        AZURE_DELEGATED = new AuthorizationGrantType("azure_delegated");
        HashSet<SimpleGrantedAuthority> authoritySet = new HashSet<SimpleGrantedAuthority>();
        authoritySet.add(new SimpleGrantedAuthority("ROLE_USER"));
        DEFAULT_AUTHORITY_SET = Collections.unmodifiableSet(authoritySet);
    }
}

