/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.actuator.implementation.storage;

import com.azure.core.http.rest.Response;
import com.azure.spring.cloud.actuator.implementation.storage.StorageHealthConstants;
import com.azure.spring.cloud.actuator.implementation.util.ActuateConstants;
import com.azure.storage.blob.BlobContainerAsyncClient;
import com.azure.storage.blob.BlobServiceAsyncClient;
import java.time.Duration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class StorageBlobHealthIndicator
extends AbstractHealthIndicator {
    private final BlobServiceAsyncClient blobServiceAsyncClient;
    private Duration timeout = ActuateConstants.DEFAULT_HEALTH_CHECK_TIMEOUT;

    public StorageBlobHealthIndicator(BlobServiceAsyncClient blobServiceAsyncClient) {
        this.blobServiceAsyncClient = blobServiceAsyncClient;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        if (this.blobServiceAsyncClient == null) {
            builder.status(StorageHealthConstants.NOT_CONFIGURED_STATUS);
            return;
        }
        BlobContainerAsyncClient containerAsyncClient = this.blobServiceAsyncClient.getBlobContainerAsyncClient("spring-cloud-azure-not-existing-container");
        Response exists = (Response)containerAsyncClient.existsWithResponse().block(this.timeout);
        if (exists == null) {
            throw new RuntimeException("Error occurred checking the container existence!");
        }
        builder.up().withDetail("URL", (Object)this.blobServiceAsyncClient.getAccountUrl());
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

