/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.autoconfigure.b2c;

import com.azure.spring.autoconfigure.b2c.AADB2CProperties;
import com.azure.spring.autoconfigure.b2c.AADB2CURL;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;

public class AADB2CLogoutSuccessHandler
extends SimpleUrlLogoutSuccessHandler {
    private final AADB2CProperties properties;

    public AADB2CLogoutSuccessHandler(@NonNull AADB2CProperties properties) {
        this.properties = properties;
        super.setDefaultTargetUrl(this.getAADB2CEndSessionUrl());
    }

    private String getAADB2CEndSessionUrl() {
        String userFlow = this.properties.getUserFlows().get(this.properties.getLoginFlow());
        String logoutSuccessUrl = this.properties.getLogoutSuccessUrl();
        return AADB2CURL.getEndSessionUrl(this.properties.getBaseUri(), logoutSuccessUrl, userFlow);
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        super.onLogoutSuccess(request, response, authentication);
    }
}

