/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.aad.webapp;

import com.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import java.util.HashMap;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

public class AADOAuth2AuthorizationRequestResolver
implements OAuth2AuthorizationRequestResolver {
    private final OAuth2AuthorizationRequestResolver defaultResolver;
    private final AADAuthenticationProperties properties;

    public AADOAuth2AuthorizationRequestResolver(ClientRegistrationRepository clientRegistrationRepository, AADAuthenticationProperties properties) {
        this.defaultResolver = new DefaultOAuth2AuthorizationRequestResolver(clientRegistrationRepository, "/oauth2/authorization");
        this.properties = properties;
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request) {
        return this.addClaims(request, this.defaultResolver.resolve(request));
    }

    public OAuth2AuthorizationRequest resolve(HttpServletRequest request, String clientRegistrationId) {
        return this.addClaims(request, this.defaultResolver.resolve(request, clientRegistrationId));
    }

    private OAuth2AuthorizationRequest addClaims(HttpServletRequest httpServletRequest, OAuth2AuthorizationRequest oAuth2AuthorizationRequest) {
        if (oAuth2AuthorizationRequest == null || httpServletRequest == null) {
            return oAuth2AuthorizationRequest;
        }
        String conditionalAccessPolicyClaims = Optional.of(httpServletRequest).map(r -> r.getSession(false)).map(httpSession -> {
            String claims = (String)httpSession.getAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS");
            if (claims != null) {
                httpSession.removeAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS");
            }
            return claims;
        }).orElse(null);
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        if (conditionalAccessPolicyClaims != null) {
            additionalParameters.put("claims", conditionalAccessPolicyClaims);
        }
        Optional.ofNullable(this.properties).map(AADAuthenticationProperties::getAuthenticateAdditionalParameters).ifPresent(additionalParameters::putAll);
        Optional.of(oAuth2AuthorizationRequest).map(OAuth2AuthorizationRequest::getAdditionalParameters).ifPresent(additionalParameters::putAll);
        return OAuth2AuthorizationRequest.from((OAuth2AuthorizationRequest)oAuth2AuthorizationRequest).additionalParameters(additionalParameters).build();
    }
}

