/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyPropertiesMetrics;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyPropertiesPriorityReplication;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class ObjectReplicationPolicyProperties
implements JsonSerializable<ObjectReplicationPolicyProperties> {
    private String policyId;
    private OffsetDateTime enabledTime;
    private String sourceAccount;
    private String destinationAccount;
    private List<ObjectReplicationPolicyRule> rules;
    private ObjectReplicationPolicyPropertiesMetrics metrics;
    private ObjectReplicationPolicyPropertiesPriorityReplication priorityReplication;
    private static final ClientLogger LOGGER = new ClientLogger(ObjectReplicationPolicyProperties.class);

    public String policyId() {
        return this.policyId;
    }

    public OffsetDateTime enabledTime() {
        return this.enabledTime;
    }

    public String sourceAccount() {
        return this.sourceAccount;
    }

    public ObjectReplicationPolicyProperties withSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    public String destinationAccount() {
        return this.destinationAccount;
    }

    public ObjectReplicationPolicyProperties withDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    public List<ObjectReplicationPolicyRule> rules() {
        return this.rules;
    }

    public ObjectReplicationPolicyProperties withRules(List<ObjectReplicationPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public ObjectReplicationPolicyPropertiesMetrics metrics() {
        return this.metrics;
    }

    public ObjectReplicationPolicyProperties withMetrics(ObjectReplicationPolicyPropertiesMetrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ObjectReplicationPolicyPropertiesPriorityReplication priorityReplication() {
        return this.priorityReplication;
    }

    public ObjectReplicationPolicyProperties withPriorityReplication(ObjectReplicationPolicyPropertiesPriorityReplication priorityReplication) {
        this.priorityReplication = priorityReplication;
        return this;
    }

    public void validate() {
        if (this.sourceAccount() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.destinationAccount() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property destinationAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
        if (this.metrics() != null) {
            this.metrics().validate();
        }
        if (this.priorityReplication() != null) {
            this.priorityReplication().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceAccount", this.sourceAccount);
        jsonWriter.writeStringField("destinationAccount", this.destinationAccount);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("metrics", (JsonSerializable)this.metrics);
        jsonWriter.writeJsonField("priorityReplication", (JsonSerializable)this.priorityReplication);
        return jsonWriter.writeEndObject();
    }

    public static ObjectReplicationPolicyProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ObjectReplicationPolicyProperties)jsonReader.readObject(reader -> {
            ObjectReplicationPolicyProperties deserializedObjectReplicationPolicyProperties = new ObjectReplicationPolicyProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceAccount".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.sourceAccount = reader.getString();
                    continue;
                }
                if ("destinationAccount".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.destinationAccount = reader.getString();
                    continue;
                }
                if ("policyId".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.policyId = reader.getString();
                    continue;
                }
                if ("enabledTime".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.enabledTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("rules".equals(fieldName)) {
                    List rules;
                    deserializedObjectReplicationPolicyProperties.rules = rules = reader.readArray(reader1 -> ObjectReplicationPolicyRule.fromJson(reader1));
                    continue;
                }
                if ("metrics".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.metrics = ObjectReplicationPolicyPropertiesMetrics.fromJson(reader);
                    continue;
                }
                if ("priorityReplication".equals(fieldName)) {
                    deserializedObjectReplicationPolicyProperties.priorityReplication = ObjectReplicationPolicyPropertiesPriorityReplication.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedObjectReplicationPolicyProperties;
        });
    }
}

