/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.RunResult;
import com.azure.resourcemanager.storage.models.RunStatusEnum;
import java.io.IOException;

public final class StorageTaskReportProperties
implements JsonSerializable<StorageTaskReportProperties> {
    private String taskAssignmentId;
    private String storageAccountId;
    private String startTime;
    private String finishTime;
    private String objectsTargetedCount;
    private String objectsOperatedOnCount;
    private String objectFailedCount;
    private String objectsSucceededCount;
    private String runStatusError;
    private RunStatusEnum runStatusEnum;
    private String summaryReportPath;
    private String taskId;
    private String taskVersion;
    private RunResult runResult;

    public String taskAssignmentId() {
        return this.taskAssignmentId;
    }

    public String storageAccountId() {
        return this.storageAccountId;
    }

    public String startTime() {
        return this.startTime;
    }

    public String finishTime() {
        return this.finishTime;
    }

    public String objectsTargetedCount() {
        return this.objectsTargetedCount;
    }

    public String objectsOperatedOnCount() {
        return this.objectsOperatedOnCount;
    }

    public String objectFailedCount() {
        return this.objectFailedCount;
    }

    public String objectsSucceededCount() {
        return this.objectsSucceededCount;
    }

    public String runStatusError() {
        return this.runStatusError;
    }

    public RunStatusEnum runStatusEnum() {
        return this.runStatusEnum;
    }

    public String summaryReportPath() {
        return this.summaryReportPath;
    }

    public String taskId() {
        return this.taskId;
    }

    public String taskVersion() {
        return this.taskVersion;
    }

    public RunResult runResult() {
        return this.runResult;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static StorageTaskReportProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StorageTaskReportProperties)jsonReader.readObject(reader -> {
            StorageTaskReportProperties deserializedStorageTaskReportProperties = new StorageTaskReportProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("taskAssignmentId".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.taskAssignmentId = reader.getString();
                    continue;
                }
                if ("storageAccountId".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.storageAccountId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.startTime = reader.getString();
                    continue;
                }
                if ("finishTime".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.finishTime = reader.getString();
                    continue;
                }
                if ("objectsTargetedCount".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.objectsTargetedCount = reader.getString();
                    continue;
                }
                if ("objectsOperatedOnCount".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.objectsOperatedOnCount = reader.getString();
                    continue;
                }
                if ("objectFailedCount".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.objectFailedCount = reader.getString();
                    continue;
                }
                if ("objectsSucceededCount".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.objectsSucceededCount = reader.getString();
                    continue;
                }
                if ("runStatusError".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.runStatusError = reader.getString();
                    continue;
                }
                if ("runStatusEnum".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.runStatusEnum = RunStatusEnum.fromString(reader.getString());
                    continue;
                }
                if ("summaryReportPath".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.summaryReportPath = reader.getString();
                    continue;
                }
                if ("taskId".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.taskId = reader.getString();
                    continue;
                }
                if ("taskVersion".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.taskVersion = reader.getString();
                    continue;
                }
                if ("runResult".equals(fieldName)) {
                    deserializedStorageTaskReportProperties.runResult = RunResult.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageTaskReportProperties;
        });
    }
}

