/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.TagFilter;
import java.io.IOException;
import java.util.List;

public final class ManagementPolicyFilter
implements JsonSerializable<ManagementPolicyFilter> {
    private List<String> prefixMatch;
    private List<String> blobTypes;
    private List<TagFilter> blobIndexMatch;
    private static final ClientLogger LOGGER = new ClientLogger(ManagementPolicyFilter.class);

    public List<String> prefixMatch() {
        return this.prefixMatch;
    }

    public ManagementPolicyFilter withPrefixMatch(List<String> prefixMatch) {
        this.prefixMatch = prefixMatch;
        return this;
    }

    public List<String> blobTypes() {
        return this.blobTypes;
    }

    public ManagementPolicyFilter withBlobTypes(List<String> blobTypes) {
        this.blobTypes = blobTypes;
        return this;
    }

    public List<TagFilter> blobIndexMatch() {
        return this.blobIndexMatch;
    }

    public ManagementPolicyFilter withBlobIndexMatch(List<TagFilter> blobIndexMatch) {
        this.blobIndexMatch = blobIndexMatch;
        return this;
    }

    public void validate() {
        if (this.blobTypes() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property blobTypes in model ManagementPolicyFilter"));
        }
        if (this.blobIndexMatch() != null) {
            this.blobIndexMatch().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("blobTypes", this.blobTypes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("prefixMatch", this.prefixMatch, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("blobIndexMatch", this.blobIndexMatch, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ManagementPolicyFilter fromJson(JsonReader jsonReader) throws IOException {
        return (ManagementPolicyFilter)jsonReader.readObject(reader -> {
            ManagementPolicyFilter deserializedManagementPolicyFilter = new ManagementPolicyFilter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("blobTypes".equals(fieldName)) {
                    List blobTypes;
                    deserializedManagementPolicyFilter.blobTypes = blobTypes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("prefixMatch".equals(fieldName)) {
                    List prefixMatch;
                    deserializedManagementPolicyFilter.prefixMatch = prefixMatch = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("blobIndexMatch".equals(fieldName)) {
                    List blobIndexMatch;
                    deserializedManagementPolicyFilter.blobIndexMatch = blobIndexMatch = reader.readArray(reader1 -> TagFilter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedManagementPolicyFilter;
        });
    }
}

