/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.storage.models.Action;
import java.io.IOException;

public final class IpRule
implements JsonSerializable<IpRule> {
    private String ipAddressOrRange;
    private Action action;
    private static final ClientLogger LOGGER = new ClientLogger(IpRule.class);

    public String ipAddressOrRange() {
        return this.ipAddressOrRange;
    }

    public IpRule withIpAddressOrRange(String ipAddressOrRange) {
        this.ipAddressOrRange = ipAddressOrRange;
        return this;
    }

    public Action action() {
        return this.action;
    }

    public IpRule withAction(Action action) {
        this.action = action;
        return this;
    }

    public void validate() {
        if (this.ipAddressOrRange() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ipAddressOrRange in model IpRule"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("value", this.ipAddressOrRange);
        jsonWriter.writeStringField("action", this.action == null ? null : this.action.toString());
        return jsonWriter.writeEndObject();
    }

    public static IpRule fromJson(JsonReader jsonReader) throws IOException {
        return (IpRule)jsonReader.readObject(reader -> {
            IpRule deserializedIpRule = new IpRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    deserializedIpRule.ipAddressOrRange = reader.getString();
                    continue;
                }
                if ("action".equals(fieldName)) {
                    deserializedIpRule.action = Action.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIpRule;
        });
    }
}

